/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.Packet;

class ConnectionDetachedPacketCollector {
    private ArrayBlockingQueue<Packet> resultQueue;

    public ConnectionDetachedPacketCollector() {
        this(SmackConfiguration.getPacketCollectorSize());
    }

    public ConnectionDetachedPacketCollector(int n) {
        this.resultQueue = new ArrayBlockingQueue(n);
    }

    public Packet pollResult() {
        return this.resultQueue.poll();
    }

    public Packet nextResult() {
        try {
            return this.resultQueue.take();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public Packet nextResult(long l) {
        try {
            return this.resultQueue.poll(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    protected void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        while (!this.resultQueue.offer(packet)) {
            this.resultQueue.poll();
        }
    }
}

