/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.ConnectionDetachedPacketCollector;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.RoomListenerMultiplexor;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.MUCAdmin;
import org.jivesoftware.smackx.muc.packet.MUCInitialPresence;
import org.jivesoftware.smackx.muc.packet.MUCOwner;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.xdata.Form;

public class MultiUserChat {
    private static final Logger LOGGER = Logger.getLogger(MultiUserChat.class.getName());
    private static final String discoNamespace = "http://jabber.org/protocol/muc";
    private static final String discoNode = "http://jabber.org/protocol/muc#rooms";
    private static Map<XMPPConnection, List<String>> joinedRooms = new WeakHashMap<XMPPConnection, List<String>>();
    private XMPPConnection connection;
    private String room;
    private String subject;
    private String nickname = null;
    private boolean joined = false;
    private Map<String, Presence> occupantsMap = new ConcurrentHashMap<String, Presence>();
    private final List<InvitationRejectionListener> invitationRejectionListeners = new ArrayList<InvitationRejectionListener>();
    private final List<SubjectUpdatedListener> subjectUpdatedListeners = new ArrayList<SubjectUpdatedListener>();
    private final List<UserStatusListener> userStatusListeners = new ArrayList<UserStatusListener>();
    private final List<ParticipantStatusListener> participantStatusListeners = new ArrayList<ParticipantStatusListener>();
    private PacketFilter presenceFilter;
    private List<PacketInterceptor> presenceInterceptors = new ArrayList<PacketInterceptor>();
    private PacketFilter messageFilter;
    private RoomListenerMultiplexor roomListenerMultiplexor;
    private ConnectionDetachedPacketCollector messageCollector;
    private List<PacketListener> connectionListeners = new ArrayList<PacketListener>();

    public MultiUserChat(XMPPConnection xMPPConnection, String string) {
        this.connection = xMPPConnection;
        this.room = string.toLowerCase(Locale.US);
        this.init();
    }

    public static boolean isServiceEnabled(XMPPConnection xMPPConnection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(xMPPConnection).supportsFeature(string, discoNamespace);
    }

    private static List<String> getJoinedRooms(XMPPConnection xMPPConnection) {
        List<String> list = joinedRooms.get(xMPPConnection);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static List<String> getJoinedRooms(XMPPConnection xMPPConnection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        DiscoverItems discoverItems = ServiceDiscoveryManager.getInstanceFor(xMPPConnection).discoverItems(string, discoNode);
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            arrayList.add(item.getEntityID());
        }
        return arrayList;
    }

    public static RoomInfo getRoomInfo(XMPPConnection xMPPConnection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(xMPPConnection).discoverInfo(string);
        return new RoomInfo(discoverInfo);
    }

    public static Collection<String> getServiceNames(XMPPConnection xMPPConnection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(xMPPConnection.getServiceName());
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
            if (!discoverInfo.containsFeature(discoNamespace)) continue;
            arrayList.add(item.getEntityID());
        }
        return arrayList;
    }

    public static Collection<HostedRoom> getHostedRooms(XMPPConnection xMPPConnection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<HostedRoom> arrayList = new ArrayList<HostedRoom>();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(string);
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            arrayList.add(new HostedRoom(item));
        }
        return arrayList;
    }

    public String getRoom() {
        return this.room;
    }

    private Presence enter(String string, String string2, DiscussionHistory discussionHistory, long l) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        if (StringUtils.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        Presence presence = new Presence(Presence.Type.available);
        presence.setTo(this.room + "/" + string);
        MUCInitialPresence mUCInitialPresence = new MUCInitialPresence();
        if (string2 != null) {
            mUCInitialPresence.setPassword(string2);
        }
        if (discussionHistory != null) {
            mUCInitialPresence.setHistory(discussionHistory.getMUCHistory());
        }
        presence.addExtension(mUCInitialPresence);
        for (PacketInterceptor object2 : this.presenceInterceptors) {
            object2.interceptPacket(presence);
        }
        AndFilter andFilter = new AndFilter(FromMatchesFilter.createFull(this.room + "/" + string), new PacketTypeFilter(Presence.class));
        Object var9_9 = null;
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(presence);
        Presence presence2 = (Presence)packetCollector.nextResultOrThrow(l);
        this.nickname = string;
        this.joined = true;
        List<String> list = joinedRooms.get(this.connection);
        if (list == null) {
            list = new ArrayList<String>();
            joinedRooms.put(this.connection, list);
        }
        list.add(this.room);
        return presence2;
    }

    public synchronized void create(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException {
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        if (this.createOrJoin(string)) {
            return;
        }
        this.leave();
        throw new SmackException("Creation failed - Missing acknowledge of room creation.");
    }

    public synchronized boolean createOrJoin(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException {
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        Presence presence = this.enter(string, null, null, this.connection.getPacketReplyTimeout());
        MUCUser mUCUser = this.getMUCUserExtension(presence);
        return mUCUser != null && mUCUser.getStatus() != null && "201".equals(mUCUser.getStatus().getCode());
    }

    public void join(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.join(string, null, null, this.connection.getPacketReplyTimeout());
    }

    public void join(String string, String string2) throws XMPPException.XMPPErrorException, SmackException {
        this.join(string, string2, null, this.connection.getPacketReplyTimeout());
    }

    public synchronized void join(String string, String string2, DiscussionHistory discussionHistory, long l) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        if (this.joined) {
            this.leave();
        }
        this.enter(string, string2, discussionHistory, l);
    }

    public boolean isJoined() {
        return this.joined;
    }

    public synchronized void leave() throws SmackException.NotConnectedException {
        if (!this.joined) {
            return;
        }
        Presence presence = new Presence(Presence.Type.unavailable);
        presence.setTo(this.room + "/" + this.nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(presence);
        }
        this.connection.sendPacket(presence);
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public Form getConfigurationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.GET);
        IQ iQ = (IQ)this.connection.createPacketCollectorAndSend(mUCOwner).nextResultOrThrow();
        return Form.getFormFrom(iQ);
    }

    public void sendConfigurationForm(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.SET);
        mUCOwner.addExtension(form.getDataFormToSend());
        this.connection.createPacketCollectorAndSend(mUCOwner).nextResultOrThrow();
    }

    public Form getRegistrationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.GET);
        registration.setTo(this.room);
        IQ iQ = (IQ)this.connection.createPacketCollectorAndSend(registration).nextResultOrThrow();
        return Form.getFormFrom(iQ);
    }

    public void sendRegistrationForm(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.room);
        registration.addExtension(form.getDataFormToSend());
        this.connection.createPacketCollectorAndSend(registration).nextResultOrThrow();
    }

    public void destroy(String string, String string2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.SET);
        MUCOwner.Destroy destroy = new MUCOwner.Destroy();
        destroy.setReason(string);
        destroy.setJid(string2);
        mUCOwner.setDestroy(destroy);
        this.connection.createPacketCollectorAndSend(mUCOwner).nextResultOrThrow();
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public void invite(String string, String string2) throws SmackException.NotConnectedException {
        this.invite(new Message(), string, string2);
    }

    public void invite(Message message, String string, String string2) throws SmackException.NotConnectedException {
        message.setTo(this.room);
        MUCUser mUCUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setTo(string);
        invite.setReason(string2);
        mUCUser.setInvite(invite);
        message.addExtension(mUCUser);
        this.connection.sendPacket(message);
    }

    public static void decline(XMPPConnection xMPPConnection, String string, String string2, String string3) throws SmackException.NotConnectedException {
        Message message = new Message(string);
        MUCUser mUCUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setTo(string2);
        decline.setReason(string3);
        mUCUser.setDecline(decline);
        message.addExtension(mUCUser);
        xMPPConnection.sendPacket(message);
    }

    public static void addInvitationListener(XMPPConnection xMPPConnection, InvitationListener invitationListener) {
        InvitationsMonitor.getInvitationsMonitor(xMPPConnection).addInvitationListener(invitationListener);
    }

    public static void removeInvitationListener(XMPPConnection xMPPConnection, InvitationListener invitationListener) {
        InvitationsMonitor.getInvitationsMonitor(xMPPConnection).removeInvitationListener(invitationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationRejectionListener(InvitationRejectionListener invitationRejectionListener) {
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            if (!this.invitationRejectionListeners.contains(invitationRejectionListener)) {
                this.invitationRejectionListeners.add(invitationRejectionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationRejectionListener(InvitationRejectionListener invitationRejectionListener) {
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            this.invitationRejectionListeners.remove(invitationRejectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationRejectionListeners(String string, String string2) {
        InvitationRejectionListener[] invitationRejectionListenerArray = this.invitationRejectionListeners;
        synchronized (this.invitationRejectionListeners) {
            InvitationRejectionListener[] invitationRejectionListenerArray2 = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(invitationRejectionListenerArray2);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (InvitationRejectionListener invitationRejectionListener : invitationRejectionListenerArray2) {
                invitationRejectionListener.invitationDeclined(string, string2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubjectUpdatedListener(SubjectUpdatedListener subjectUpdatedListener) {
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            if (!this.subjectUpdatedListeners.contains(subjectUpdatedListener)) {
                this.subjectUpdatedListeners.add(subjectUpdatedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubjectUpdatedListener(SubjectUpdatedListener subjectUpdatedListener) {
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            this.subjectUpdatedListeners.remove(subjectUpdatedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSubjectUpdatedListeners(String string, String string2) {
        SubjectUpdatedListener[] subjectUpdatedListenerArray = this.subjectUpdatedListeners;
        synchronized (this.subjectUpdatedListeners) {
            SubjectUpdatedListener[] subjectUpdatedListenerArray2 = new SubjectUpdatedListener[this.subjectUpdatedListeners.size()];
            this.subjectUpdatedListeners.toArray(subjectUpdatedListenerArray2);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (SubjectUpdatedListener subjectUpdatedListener : subjectUpdatedListenerArray2) {
                subjectUpdatedListener.subjectUpdated(string, string2);
            }
            return;
        }
    }

    public void addPresenceInterceptor(PacketInterceptor packetInterceptor) {
        this.presenceInterceptors.add(packetInterceptor);
    }

    public void removePresenceInterceptor(PacketInterceptor packetInterceptor) {
        this.presenceInterceptors.remove(packetInterceptor);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() throws SmackException {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.room, "x-roomuser-item");
            Iterator<DiscoverInfo.Identity> iterator = discoverInfo.getIdentities().iterator();
            if (iterator.hasNext()) {
                DiscoverInfo.Identity identity = iterator.next();
                return identity.getName();
            }
        }
        catch (XMPPException xMPPException) {
            LOGGER.log(Level.SEVERE, "Error retrieving room nickname", xMPPException);
        }
        return null;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void changeNickname(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (StringUtils.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change nickname.");
        }
        Presence presence = new Presence(Presence.Type.available);
        presence.setTo(this.room + "/" + string);
        for (PacketInterceptor object2 : this.presenceInterceptors) {
            object2.interceptPacket(presence);
        }
        AndFilter andFilter = new AndFilter(FromMatchesFilter.createFull(this.room + "/" + string), new PacketTypeFilter(Presence.class));
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(presence);
        packetCollector.nextResultOrThrow();
        this.nickname = string;
    }

    public void changeAvailabilityStatus(String string, Presence.Mode mode) throws SmackException.NotConnectedException {
        if (StringUtils.isNullOrEmpty(this.nickname)) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change the availability status.");
        }
        Presence presence = new Presence(Presence.Type.available);
        presence.setStatus(string);
        presence.setMode(mode);
        presence.setTo(this.room + "/" + this.nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(presence);
        }
        this.connection.sendPacket(presence);
    }

    public void kickParticipant(String string, String string2) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(string, "none", string2);
    }

    public void grantVoice(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(collection, "participant");
    }

    public void grantVoice(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(string, "participant", null);
    }

    public void revokeVoice(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(collection, "visitor");
    }

    public void revokeVoice(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(string, "visitor", null);
    }

    public void banUsers(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(collection, "outcast");
    }

    public void banUser(String string, String string2) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(string, "outcast", string2);
    }

    public void grantMembership(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(collection, "member");
    }

    public void grantMembership(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(string, "member", null);
    }

    public void revokeMembership(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(collection, "none");
    }

    public void revokeMembership(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(string, "none", null);
    }

    public void grantModerator(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(collection, "moderator");
    }

    public void grantModerator(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(string, "moderator", null);
    }

    public void revokeModerator(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(collection, "participant");
    }

    public void revokeModerator(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(string, "participant", null);
    }

    public void grantOwnership(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(collection, "owner");
    }

    public void grantOwnership(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(string, "owner", null);
    }

    public void revokeOwnership(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(collection, "admin");
    }

    public void revokeOwnership(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(string, "admin", null);
    }

    public void grantAdmin(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByOwner(collection, "admin");
    }

    public void grantAdmin(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByOwner(string, "admin");
    }

    public void revokeAdmin(Collection<String> collection) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByOwner(collection, "member");
    }

    public void revokeAdmin(String string) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByOwner(string, "member");
    }

    private void changeAffiliationByOwner(String string, String string2) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.SET);
        MUCOwner.Item item = new MUCOwner.Item(string2);
        item.setJid(string);
        mUCOwner.addItem(item);
        this.connection.createPacketCollectorAndSend(mUCOwner).nextResultOrThrow();
    }

    private void changeAffiliationByOwner(Collection<String> collection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner mUCOwner = new MUCOwner();
        mUCOwner.setTo(this.room);
        mUCOwner.setType(IQ.Type.SET);
        for (String string2 : collection) {
            MUCOwner.Item item = new MUCOwner.Item(string);
            item.setJid(string2);
            mUCOwner.addItem(item);
        }
        this.connection.createPacketCollectorAndSend(mUCOwner).nextResultOrThrow();
    }

    private void changeAffiliationByAdmin(String string, String string2, String string3) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(string2, null);
        item.setJid(string);
        item.setReason(string3);
        mUCAdmin.addItem(item);
        this.connection.createPacketCollectorAndSend(mUCAdmin).nextResultOrThrow();
    }

    private void changeAffiliationByAdmin(Collection<String> collection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.SET);
        for (String string2 : collection) {
            MUCAdmin.Item item = new MUCAdmin.Item(string, null);
            item.setJid(string2);
            mUCAdmin.addItem(item);
        }
        this.connection.createPacketCollectorAndSend(mUCAdmin).nextResultOrThrow();
    }

    private void changeRole(String string, String string2, String string3) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, string2);
        item.setNick(string);
        item.setReason(string3);
        mUCAdmin.addItem(item);
        this.connection.createPacketCollectorAndSend(mUCAdmin).nextResultOrThrow();
    }

    private void changeRole(Collection<String> collection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.SET);
        for (String string2 : collection) {
            MUCAdmin.Item item = new MUCAdmin.Item(null, string);
            item.setNick(string2);
            mUCAdmin.addItem(item);
        }
        this.connection.createPacketCollectorAndSend(mUCAdmin).nextResultOrThrow();
    }

    public int getOccupantsCount() {
        return this.occupantsMap.size();
    }

    public List<String> getOccupants() {
        return Collections.unmodifiableList(new ArrayList<String>(this.occupantsMap.keySet()));
    }

    public Presence getOccupantPresence(String string) {
        return this.occupantsMap.get(string);
    }

    public Occupant getOccupant(String string) {
        Presence presence = this.occupantsMap.get(string);
        if (presence != null) {
            return new Occupant(presence);
        }
        return null;
    }

    public void addParticipantListener(PacketListener packetListener) {
        this.connection.addPacketListener(packetListener, this.presenceFilter);
        this.connectionListeners.add(packetListener);
    }

    public void removeParticipantListener(PacketListener packetListener) {
        this.connection.removePacketListener(packetListener);
        this.connectionListeners.remove(packetListener);
    }

    public Collection<Affiliate> getOwners() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin("owner");
    }

    public Collection<Affiliate> getAdmins() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin("admin");
    }

    public Collection<Affiliate> getMembers() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin("member");
    }

    public Collection<Affiliate> getOutcasts() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin("outcast");
    }

    private Collection<Affiliate> getAffiliatesByAdmin(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(string, null);
        mUCAdmin.addItem(item);
        MUCAdmin mUCAdmin2 = (MUCAdmin)this.connection.createPacketCollectorAndSend(mUCAdmin).nextResultOrThrow();
        ArrayList<Affiliate> arrayList = new ArrayList<Affiliate>();
        for (MUCAdmin.Item item2 : mUCAdmin2.getItems()) {
            arrayList.add(new Affiliate(item2));
        }
        return arrayList;
    }

    public Collection<Occupant> getModerators() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getOccupants("moderator");
    }

    public Collection<Occupant> getParticipants() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getOccupants("participant");
    }

    private Collection<Occupant> getOccupants(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin mUCAdmin = new MUCAdmin();
        mUCAdmin.setTo(this.room);
        mUCAdmin.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, string);
        mUCAdmin.addItem(item);
        MUCAdmin mUCAdmin2 = (MUCAdmin)this.connection.createPacketCollectorAndSend(mUCAdmin).nextResultOrThrow();
        ArrayList<Occupant> arrayList = new ArrayList<Occupant>();
        for (MUCAdmin.Item item2 : mUCAdmin2.getItems()) {
            arrayList.add(new Occupant(item2));
        }
        return arrayList;
    }

    public void sendMessage(String string) throws XMPPException, SmackException.NotConnectedException {
        Message message = new Message(this.room, Message.Type.groupchat);
        message.setBody(string);
        this.connection.sendPacket(message);
    }

    public Chat createPrivateChat(String string, MessageListener messageListener) {
        return ChatManager.getInstanceFor(this.connection).createChat(string, messageListener);
    }

    public Message createMessage() {
        return new Message(this.room, Message.Type.groupchat);
    }

    public void sendMessage(Message message) throws XMPPException, SmackException.NotConnectedException {
        this.connection.sendPacket(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long l) {
        return (Message)this.messageCollector.nextResult(l);
    }

    public void addMessageListener(PacketListener packetListener) {
        this.connection.addPacketListener(packetListener, this.messageFilter);
        this.connectionListeners.add(packetListener);
    }

    public void removeMessageListener(PacketListener packetListener) {
        this.connection.removePacketListener(packetListener);
        this.connectionListeners.remove(packetListener);
    }

    public void changeSubject(final String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Message message = new Message(this.room, Message.Type.groupchat);
        message.setSubject(string);
        AndFilter andFilter = new AndFilter(FromMatchesFilter.create(this.room), new PacketTypeFilter(Message.class));
        andFilter = new AndFilter(andFilter, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                Message message = (Message)packet;
                return string.equals(message.getSubject());
            }
        });
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        this.connection.sendPacket(message);
        packetCollector.nextResultOrThrow();
    }

    private synchronized void userHasLeft() {
        List<String> list = joinedRooms.get(this.connection);
        if (list == null) {
            return;
        }
        list.remove(this.room);
        this.cleanup();
    }

    private MUCUser getMUCUserExtension(Packet packet) {
        if (packet != null) {
            return (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserStatusListener(UserStatusListener userStatusListener) {
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            if (!this.userStatusListeners.contains(userStatusListener)) {
                this.userStatusListeners.add(userStatusListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserStatusListener(UserStatusListener userStatusListener) {
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            this.userStatusListeners.remove(userStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserStatusListeners(String string, Object[] objectArray) {
        Class[] classArray = this.userStatusListeners;
        synchronized (this.userStatusListeners) {
            UserStatusListener[] userStatusListenerArray = new UserStatusListener[this.userStatusListeners.size()];
            this.userStatusListeners.toArray(userStatusListenerArray);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
            try {
                Method method = UserStatusListener.class.getDeclaredMethod(string, classArray);
                for (UserStatusListener userStatusListener : userStatusListenerArray) {
                    method.invoke((Object)userStatusListener, objectArray);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.SEVERE, "Failed to invoke method on UserStatusListener", noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.SEVERE, "Failed to invoke method on UserStatusListener", invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.SEVERE, "Failed to invoke method on UserStatusListener", illegalAccessException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipantStatusListener(ParticipantStatusListener participantStatusListener) {
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            if (!this.participantStatusListeners.contains(participantStatusListener)) {
                this.participantStatusListeners.add(participantStatusListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipantStatusListener(ParticipantStatusListener participantStatusListener) {
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            this.participantStatusListeners.remove(participantStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireParticipantStatusListeners(String string, List<String> list) {
        Class[] classArray = this.participantStatusListeners;
        synchronized (this.participantStatusListeners) {
            ParticipantStatusListener[] participantStatusListenerArray = new ParticipantStatusListener[this.participantStatusListeners.size()];
            this.participantStatusListeners.toArray(participantStatusListenerArray);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            try {
                classArray = new Class[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    classArray[i] = String.class;
                }
                Method method = ParticipantStatusListener.class.getDeclaredMethod(string, classArray);
                for (ParticipantStatusListener participantStatusListener : participantStatusListenerArray) {
                    method.invoke((Object)participantStatusListener, list.toArray());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.SEVERE, "Failed to invoke method on ParticipantStatusListener", noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.SEVERE, "Failed to invoke method on ParticipantStatusListener", invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.SEVERE, "Failed to invoke method on ParticipantStatusListener", illegalAccessException);
            }
            return;
        }
    }

    private void init() {
        this.messageFilter = new AndFilter(FromMatchesFilter.create(this.room), new MessageTypeFilter(Message.Type.groupchat));
        this.presenceFilter = new AndFilter(FromMatchesFilter.create(this.room), new PacketTypeFilter(Presence.class));
        this.messageCollector = new ConnectionDetachedPacketCollector();
        PacketListener packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                MultiUserChat.this.subject = message.getSubject();
                MultiUserChat.this.fireSubjectUpdatedListeners(message.getSubject(), message.getFrom());
            }
        };
        PacketListener packetListener2 = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                String string = presence.getFrom();
                String string2 = MultiUserChat.this.room + "/" + MultiUserChat.this.nickname;
                boolean bl = presence.getFrom().equals(string2);
                if (presence.getType() == Presence.Type.available) {
                    Presence presence2 = MultiUserChat.this.occupantsMap.put(string, presence);
                    if (presence2 != null) {
                        MUCUser mUCUser = MultiUserChat.this.getMUCUserExtension(presence2);
                        String string3 = mUCUser.getItem().getAffiliation();
                        String string4 = mUCUser.getItem().getRole();
                        mUCUser = MultiUserChat.this.getMUCUserExtension(presence);
                        String string5 = mUCUser.getItem().getAffiliation();
                        String string6 = mUCUser.getItem().getRole();
                        MultiUserChat.this.checkRoleModifications(string4, string6, bl, string);
                        MultiUserChat.this.checkAffiliationModifications(string3, string5, bl, string);
                    } else if (!bl) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string);
                        MultiUserChat.this.fireParticipantStatusListeners("joined", arrayList);
                    }
                } else if (presence.getType() == Presence.Type.unavailable) {
                    MultiUserChat.this.occupantsMap.remove(string);
                    MUCUser mUCUser = MultiUserChat.this.getMUCUserExtension(presence);
                    if (mUCUser != null && mUCUser.getStatus() != null) {
                        MultiUserChat.this.checkPresenceCode(mUCUser.getStatus().getCode(), presence.getFrom().equals(string2), mUCUser, string);
                    } else if (!bl) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string);
                        MultiUserChat.this.fireParticipantStatusListeners("left", arrayList);
                    }
                }
            }
        };
        PacketListener packetListener3 = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                MUCUser mUCUser = MultiUserChat.this.getMUCUserExtension(packet);
                if (mUCUser.getDecline() != null && ((Message)packet).getType() != Message.Type.error) {
                    MultiUserChat.this.fireInvitationRejectionListeners(mUCUser.getDecline().getFrom(), mUCUser.getDecline().getReason());
                }
            }
        };
        PacketMultiplexListener packetMultiplexListener = new PacketMultiplexListener(this.messageCollector, packetListener2, packetListener, packetListener3);
        this.roomListenerMultiplexor = RoomListenerMultiplexor.getRoomMultiplexor(this.connection);
        this.roomListenerMultiplexor.addRoom(this.room, packetMultiplexListener);
    }

    private void checkRoleModifications(String string, String string2, boolean bl, String string3) {
        ArrayList<String> arrayList;
        if (("visitor".equals(string) || "none".equals(string)) && "participant".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("voiceGranted", new Object[0]);
            } else {
                arrayList = new ArrayList<String>();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("voiceGranted", arrayList);
            }
        } else if ("participant".equals(string) && ("visitor".equals(string2) || "none".equals(string2))) {
            if (bl) {
                this.fireUserStatusListeners("voiceRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("voiceRevoked", arrayList);
            }
        }
        if (!"moderator".equals(string) && "moderator".equals(string2)) {
            if ("visitor".equals(string) || "none".equals(string)) {
                if (bl) {
                    this.fireUserStatusListeners("voiceGranted", new Object[0]);
                } else {
                    arrayList = new ArrayList();
                    arrayList.add(string3);
                    this.fireParticipantStatusListeners("voiceGranted", arrayList);
                }
            }
            if (bl) {
                this.fireUserStatusListeners("moderatorGranted", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("moderatorGranted", arrayList);
            }
        } else if ("moderator".equals(string) && !"moderator".equals(string2)) {
            if ("visitor".equals(string2) || "none".equals(string2)) {
                if (bl) {
                    this.fireUserStatusListeners("voiceRevoked", new Object[0]);
                } else {
                    arrayList = new ArrayList();
                    arrayList.add(string3);
                    this.fireParticipantStatusListeners("voiceRevoked", arrayList);
                }
            }
            if (bl) {
                this.fireUserStatusListeners("moderatorRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("moderatorRevoked", arrayList);
            }
        }
    }

    private void checkAffiliationModifications(String string, String string2, boolean bl, String string3) {
        ArrayList<String> arrayList;
        if ("owner".equals(string) && !"owner".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("ownershipRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList<String>();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("ownershipRevoked", arrayList);
            }
        } else if ("admin".equals(string) && !"admin".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("adminRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("adminRevoked", arrayList);
            }
        } else if ("member".equals(string) && !"member".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("membershipRevoked", arrayList);
            }
        }
        if (!"owner".equals(string) && "owner".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("ownershipGranted", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("ownershipGranted", arrayList);
            }
        } else if (!"admin".equals(string) && "admin".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("adminGranted", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("adminGranted", arrayList);
            }
        } else if (!"member".equals(string) && "member".equals(string2)) {
            if (bl) {
                this.fireUserStatusListeners("membershipGranted", new Object[0]);
            } else {
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.fireParticipantStatusListeners("membershipGranted", arrayList);
            }
        }
    }

    private void checkPresenceCode(String string, boolean bl, MUCUser mUCUser, String string2) {
        if ("307".equals(string)) {
            if (bl) {
                this.joined = false;
                this.fireUserStatusListeners("kicked", new Object[]{mUCUser.getItem().getActor(), mUCUser.getItem().getReason()});
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                arrayList.add(mUCUser.getItem().getActor());
                arrayList.add(mUCUser.getItem().getReason());
                this.fireParticipantStatusListeners("kicked", arrayList);
            }
        } else if ("301".equals(string)) {
            if (bl) {
                this.joined = false;
                this.fireUserStatusListeners("banned", new Object[]{mUCUser.getItem().getActor(), mUCUser.getItem().getReason()});
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                arrayList.add(mUCUser.getItem().getActor());
                arrayList.add(mUCUser.getItem().getReason());
                this.fireParticipantStatusListeners("banned", arrayList);
            }
        } else if ("321".equals(string)) {
            if (bl) {
                this.joined = false;
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            }
        } else if ("303".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(mUCUser.getItem().getNick());
            this.fireParticipantStatusListeners("nicknameChanged", arrayList);
        }
    }

    private void cleanup() {
        try {
            if (this.connection != null) {
                this.roomListenerMultiplexor.removeRoom(this.room);
                for (PacketListener packetListener : this.connectionListeners) {
                    this.connection.removePacketListener(packetListener);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature(MultiUserChat.discoNamespace);
                final WeakReference<XMPPConnection> weakReference = new WeakReference<XMPPConnection>(xMPPConnection);
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection).setNodeInformationProvider(MultiUserChat.discoNode, new NodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        XMPPConnection xMPPConnection = (XMPPConnection)weakReference.get();
                        if (xMPPConnection == null) {
                            return new LinkedList<DiscoverItems.Item>();
                        }
                        ArrayList<DiscoverItems.Item> arrayList = new ArrayList<DiscoverItems.Item>();
                        for (String string : MultiUserChat.getJoinedRooms(xMPPConnection)) {
                            arrayList.add(new DiscoverItems.Item(string));
                        }
                        return arrayList;
                    }

                    @Override
                    public List<String> getNodeFeatures() {
                        return null;
                    }

                    @Override
                    public List<DiscoverInfo.Identity> getNodeIdentities() {
                        return null;
                    }

                    @Override
                    public List<PacketExtension> getNodePacketExtensions() {
                        return null;
                    }
                });
            }
        });
    }

    private static class InvitationsMonitor
    extends AbstractConnectionListener {
        private static final Map<XMPPConnection, WeakReference<InvitationsMonitor>> monitors = new WeakHashMap<XMPPConnection, WeakReference<InvitationsMonitor>>();
        private final List<InvitationListener> invitationsListeners = new ArrayList<InvitationListener>();
        private XMPPConnection connection;
        private PacketFilter invitationFilter;
        private PacketListener invitationPacketListener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InvitationsMonitor getInvitationsMonitor(XMPPConnection xMPPConnection) {
            Map<XMPPConnection, WeakReference<InvitationsMonitor>> map = monitors;
            synchronized (map) {
                if (!monitors.containsKey(xMPPConnection) || monitors.get(xMPPConnection).get() == null) {
                    InvitationsMonitor invitationsMonitor = new InvitationsMonitor(xMPPConnection);
                    monitors.put(xMPPConnection, new WeakReference<InvitationsMonitor>(invitationsMonitor));
                    return invitationsMonitor;
                }
                return (InvitationsMonitor)monitors.get(xMPPConnection).get();
            }
        }

        private InvitationsMonitor(XMPPConnection xMPPConnection) {
            this.connection = xMPPConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInvitationListener(InvitationListener invitationListener) {
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.size() == 0) {
                    this.init();
                }
                if (!this.invitationsListeners.contains(invitationListener)) {
                    this.invitationsListeners.add(invitationListener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeInvitationListener(InvitationListener invitationListener) {
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.contains(invitationListener)) {
                    this.invitationsListeners.remove(invitationListener);
                }
                if (this.invitationsListeners.size() == 0) {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireInvitationListeners(String string, String string2, String string3, String string4, Message message) {
            InvitationListener[] invitationListenerArray = this.invitationsListeners;
            synchronized (this.invitationsListeners) {
                InvitationListener[] invitationListenerArray2 = new InvitationListener[this.invitationsListeners.size()];
                this.invitationsListeners.toArray(invitationListenerArray2);
                // ** MonitorExit[var7_6] (shouldn't be in output)
                for (InvitationListener invitationListener : invitationListenerArray2) {
                    invitationListener.invitationReceived(this.connection, string, string2, string3, string4, message);
                }
                return;
            }
        }

        @Override
        public void connectionClosed() {
            this.cancel();
        }

        private void init() {
            this.invitationFilter = new PacketExtensionFilter("x", "http://jabber.org/protocol/muc#user");
            this.invitationPacketListener = new PacketListener(){

                @Override
                public void processPacket(Packet packet) {
                    MUCUser mUCUser = (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
                    if (mUCUser.getInvite() != null && ((Message)packet).getType() != Message.Type.error) {
                        InvitationsMonitor.this.fireInvitationListeners(packet.getFrom(), mUCUser.getInvite().getFrom(), mUCUser.getInvite().getReason(), mUCUser.getPassword(), (Message)packet);
                    }
                }
            };
            this.connection.addPacketListener(this.invitationPacketListener, this.invitationFilter);
            this.connection.addConnectionListener(this);
        }

        private void cancel() {
            this.connection.removePacketListener(this.invitationPacketListener);
            this.connection.removeConnectionListener(this);
        }
    }
}

