/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;

class RoomListenerMultiplexor
extends AbstractConnectionListener {
    private static final Map<XMPPConnection, WeakReference<RoomListenerMultiplexor>> monitors = new WeakHashMap<XMPPConnection, WeakReference<RoomListenerMultiplexor>>();
    private XMPPConnection connection;
    private RoomMultiplexFilter filter;
    private RoomMultiplexListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomListenerMultiplexor getRoomMultiplexor(XMPPConnection xMPPConnection) {
        Map<XMPPConnection, WeakReference<RoomListenerMultiplexor>> map = monitors;
        synchronized (map) {
            if (!monitors.containsKey(xMPPConnection) || monitors.get(xMPPConnection).get() == null) {
                RoomListenerMultiplexor roomListenerMultiplexor = new RoomListenerMultiplexor(xMPPConnection, new RoomMultiplexFilter(), new RoomMultiplexListener());
                roomListenerMultiplexor.init();
                monitors.put(xMPPConnection, new WeakReference<RoomListenerMultiplexor>(roomListenerMultiplexor));
            }
            return (RoomListenerMultiplexor)monitors.get(xMPPConnection).get();
        }
    }

    private RoomListenerMultiplexor(XMPPConnection xMPPConnection, RoomMultiplexFilter roomMultiplexFilter, RoomMultiplexListener roomMultiplexListener) {
        if (xMPPConnection == null) {
            throw new IllegalArgumentException("XMPPConnection is null");
        }
        if (roomMultiplexFilter == null) {
            throw new IllegalArgumentException("Filter is null");
        }
        if (roomMultiplexListener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.connection = xMPPConnection;
        this.filter = roomMultiplexFilter;
        this.listener = roomMultiplexListener;
    }

    public void addRoom(String string, PacketMultiplexListener packetMultiplexListener) {
        this.filter.addRoom(string);
        this.listener.addRoom(string, packetMultiplexListener);
    }

    @Override
    public void connectionClosed() {
        this.cancel();
    }

    @Override
    public void connectionClosedOnError(Exception exception) {
        this.cancel();
    }

    public void init() {
        this.connection.addConnectionListener(this);
        this.connection.addPacketListener(this.listener, this.filter);
    }

    public void removeRoom(String string) {
        this.filter.removeRoom(string);
        this.listener.removeRoom(string);
    }

    private void cancel() {
        this.connection.removeConnectionListener(this);
        this.connection.removePacketListener(this.listener);
    }

    private static class RoomMultiplexListener
    implements PacketListener {
        private Map<String, PacketMultiplexListener> roomListenersByAddress = new ConcurrentHashMap<String, PacketMultiplexListener>();

        private RoomMultiplexListener() {
        }

        @Override
        public void processPacket(Packet packet) throws SmackException.NotConnectedException {
            String string = packet.getFrom();
            if (string == null) {
                return;
            }
            PacketMultiplexListener packetMultiplexListener = this.roomListenersByAddress.get(StringUtils.parseBareAddress(string).toLowerCase(Locale.US));
            if (packetMultiplexListener != null) {
                packetMultiplexListener.processPacket(packet);
            }
        }

        public void addRoom(String string, PacketMultiplexListener packetMultiplexListener) {
            if (string == null) {
                return;
            }
            this.roomListenersByAddress.put(string.toLowerCase(Locale.US), packetMultiplexListener);
        }

        public void removeRoom(String string) {
            if (string == null) {
                return;
            }
            this.roomListenersByAddress.remove(string.toLowerCase(Locale.US));
        }
    }

    private static class RoomMultiplexFilter
    implements PacketFilter {
        private Map<String, String> roomAddressTable = new ConcurrentHashMap<String, String>();

        private RoomMultiplexFilter() {
        }

        @Override
        public boolean accept(Packet packet) {
            String string = packet.getFrom();
            if (string == null) {
                return false;
            }
            return this.roomAddressTable.containsKey(StringUtils.parseBareAddress(string).toLowerCase(Locale.US));
        }

        public void addRoom(String string) {
            if (string == null) {
                return;
            }
            this.roomAddressTable.put(string.toLowerCase(Locale.US), string);
        }

        public void removeRoom(String string) {
            if (string == null) {
                return;
            }
            this.roomAddressTable.remove(string.toLowerCase(Locale.US));
        }
    }
}

