/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.xmlpull.v1.XmlPullParser;

public class MUCUserProvider
implements PacketExtensionProvider {
    @Override
    public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
        MUCUser mUCUser = new MUCUser();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("invite")) {
                    mUCUser.setInvite(this.parseInvite(xmlPullParser));
                }
                if (xmlPullParser.getName().equals("item")) {
                    mUCUser.setItem(this.parseItem(xmlPullParser));
                }
                if (xmlPullParser.getName().equals("password")) {
                    mUCUser.setPassword(xmlPullParser.nextText());
                }
                if (xmlPullParser.getName().equals("status")) {
                    mUCUser.setStatus(new MUCUser.Status(xmlPullParser.getAttributeValue("", "code")));
                }
                if (xmlPullParser.getName().equals("decline")) {
                    mUCUser.setDecline(this.parseDecline(xmlPullParser));
                }
                if (!xmlPullParser.getName().equals("destroy")) continue;
                mUCUser.setDestroy(this.parseDestroy(xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("x")) continue;
            bl = true;
        }
        return mUCUser;
    }

    private MUCUser.Item parseItem(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        MUCUser.Item item = new MUCUser.Item(xmlPullParser.getAttributeValue("", "affiliation"), xmlPullParser.getAttributeValue("", "role"));
        item.setNick(xmlPullParser.getAttributeValue("", "nick"));
        item.setJid(xmlPullParser.getAttributeValue("", "jid"));
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("actor")) {
                    item.setActor(xmlPullParser.getAttributeValue("", "jid"));
                }
                if (!xmlPullParser.getName().equals("reason")) continue;
                item.setReason(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("item")) continue;
            bl = true;
        }
        return item;
    }

    private MUCUser.Invite parseInvite(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setFrom(xmlPullParser.getAttributeValue("", "from"));
        invite.setTo(xmlPullParser.getAttributeValue("", "to"));
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (!xmlPullParser.getName().equals("reason")) continue;
                invite.setReason(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("invite")) continue;
            bl = true;
        }
        return invite;
    }

    private MUCUser.Decline parseDecline(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setFrom(xmlPullParser.getAttributeValue("", "from"));
        decline.setTo(xmlPullParser.getAttributeValue("", "to"));
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (!xmlPullParser.getName().equals("reason")) continue;
                decline.setReason(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("decline")) continue;
            bl = true;
        }
        return decline;
    }

    private MUCUser.Destroy parseDestroy(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        MUCUser.Destroy destroy = new MUCUser.Destroy();
        destroy.setJid(xmlPullParser.getAttributeValue("", "jid"));
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (!xmlPullParser.getName().equals("reason")) continue;
                destroy.setReason(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("destroy")) continue;
            bl = true;
        }
        return destroy;
    }
}

