/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.offline.OfflineMessageHeader;
import org.jivesoftware.smackx.offline.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.offline.packet.OfflineMessageRequest;
import org.jivesoftware.smackx.xdata.Form;

public class OfflineMessageManager {
    private static final String namespace = "http://jabber.org/protocol/offline";
    private XMPPConnection connection;
    private PacketFilter packetFilter;

    public OfflineMessageManager(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.packetFilter = new AndFilter(new PacketExtensionFilter("offline", namespace), new PacketTypeFilter(Message.class));
    }

    public boolean supportsFlexibleRetrieval() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection).supportsFeature(this.connection.getServiceName(), namespace);
    }

    public int getMessageCount() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(null, namespace);
        Form form = Form.getFormFrom(discoverInfo);
        if (form != null) {
            String string = form.getField("number_of_messages").getValues().get(0);
            return Integer.parseInt(string);
        }
        return 0;
    }

    public List<OfflineMessageHeader> getHeaders() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<OfflineMessageHeader> arrayList = new ArrayList<OfflineMessageHeader>();
        DiscoverItems discoverItems = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverItems(null, namespace);
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            arrayList.add(new OfflineMessageHeader(item));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages(final List<String> list) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Object object;
        ArrayList<Message> arrayList = new ArrayList<Message>();
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        for (String object22 : list) {
            object = new OfflineMessageRequest.Item(object22);
            ((OfflineMessageRequest.Item)object).setAction("view");
            offlineMessageRequest.addItem((OfflineMessageRequest.Item)object);
        }
        AndFilter andFilter = new AndFilter(this.packetFilter, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                OfflineMessageInfo offlineMessageInfo = (OfflineMessageInfo)packet.getExtension("offline", OfflineMessageManager.namespace);
                return list.contains(offlineMessageInfo.getNode());
            }
        });
        PacketCollector packetCollector = this.connection.createPacketCollector(andFilter);
        try {
            this.connection.createPacketCollectorAndSend(offlineMessageRequest).nextResultOrThrow();
            object = (Message)packetCollector.nextResult();
            while (object != null) {
                arrayList.add((Message)object);
                object = (Message)packetCollector.nextResult();
            }
        }
        finally {
            packetCollector.cancel();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setFetch(true);
        PacketCollector packetCollector = this.connection.createPacketCollector(this.packetFilter);
        try {
            this.connection.createPacketCollectorAndSend(offlineMessageRequest).nextResultOrThrow();
            Message message = (Message)packetCollector.nextResult();
            while (message != null) {
                arrayList.add(message);
                message = (Message)packetCollector.nextResult();
            }
        }
        finally {
            packetCollector.cancel();
        }
        return arrayList;
    }

    public void deleteMessages(List<String> list) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        for (String string : list) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(string);
            item.setAction("remove");
            offlineMessageRequest.addItem(item);
        }
        this.connection.createPacketCollectorAndSend(offlineMessageRequest).nextResultOrThrow();
    }

    public void deleteMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setPurge(true);
        this.connection.createPacketCollectorAndSend(offlineMessageRequest).nextResultOrThrow();
    }
}

