/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.privacy.PrivacyList;
import org.jivesoftware.smackx.privacy.PrivacyListListener;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public class PrivacyListManager
extends Manager {
    public static final String NAMESPACE = "jabber:iq:privacy";
    private static final PacketFilter PACKET_FILTER = new AndFilter(new IQTypeFilter(IQ.Type.SET), new PacketExtensionFilter("query", "jabber:iq:privacy"));
    private static final Map<XMPPConnection, PrivacyListManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private final List<PrivacyListListener> listeners = new ArrayList<PrivacyListListener>();

    private PrivacyListManager(final XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        instances.put(xMPPConnection, this);
        xMPPConnection.addPacketListener(new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                Privacy privacy = (Privacy)packet;
                Object object = PrivacyListManager.this.listeners;
                synchronized (object) {
                    for (PrivacyListListener privacyListListener : PrivacyListManager.this.listeners) {
                        for (Map.Entry<String, List<PrivacyItem>> entry : privacy.getItemLists().entrySet()) {
                            String string = entry.getKey();
                            List<PrivacyItem> list = entry.getValue();
                            if (list.isEmpty()) {
                                privacyListListener.updatedPrivacyList(string);
                                continue;
                            }
                            privacyListListener.setPrivacyList(string, list);
                        }
                    }
                }
                object = IQ.createResultIQ(privacy);
                xMPPConnection.sendPacket((Packet)object);
            }
        }, PACKET_FILTER);
    }

    private String getUser() {
        return this.connection().getUser();
    }

    public static synchronized PrivacyListManager getInstanceFor(XMPPConnection xMPPConnection) {
        PrivacyListManager privacyListManager = instances.get(xMPPConnection);
        if (privacyListManager == null) {
            privacyListManager = new PrivacyListManager(xMPPConnection);
        }
        return privacyListManager;
    }

    private Privacy getRequest(Privacy privacy) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        privacy.setType(IQ.Type.GET);
        privacy.setFrom(this.getUser());
        Privacy privacy2 = (Privacy)this.connection().createPacketCollectorAndSend(privacy).nextResultOrThrow();
        return privacy2;
    }

    private Packet setRequest(Privacy privacy) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        privacy.setType(IQ.Type.SET);
        privacy.setFrom(this.getUser());
        return this.connection().createPacketCollectorAndSend(privacy).nextResultOrThrow();
    }

    private Privacy getPrivacyWithListNames() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = new Privacy();
        return this.getRequest(privacy);
    }

    public PrivacyList getActiveList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = this.getPrivacyWithListNames();
        String string = privacy.getActiveName();
        boolean bl = privacy.getActiveName() != null && privacy.getDefaultName() != null && privacy.getActiveName().equals(privacy.getDefaultName());
        return new PrivacyList(true, bl, string, this.getPrivacyListItems(string));
    }

    public PrivacyList getDefaultList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = this.getPrivacyWithListNames();
        String string = privacy.getDefaultName();
        boolean bl = privacy.getActiveName() != null && privacy.getDefaultName() != null && privacy.getActiveName().equals(privacy.getDefaultName());
        return new PrivacyList(bl, true, string, this.getPrivacyListItems(string));
    }

    private List<PrivacyItem> getPrivacyListItems(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, new ArrayList<PrivacyItem>());
        Privacy privacy2 = this.getRequest(privacy);
        return privacy2.getPrivacyList(string);
    }

    public PrivacyList getPrivacyList(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return new PrivacyList(false, false, string, this.getPrivacyListItems(string));
    }

    public PrivacyList[] getPrivacyLists() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = this.getPrivacyWithListNames();
        Set<String> set = privacy.getPrivacyListNames();
        PrivacyList[] privacyListArray = new PrivacyList[set.size()];
        int n = 0;
        for (String string : set) {
            boolean bl = string.equals(privacy.getActiveName());
            boolean bl2 = string.equals(privacy.getDefaultName());
            privacyListArray[n] = new PrivacyList(bl, bl2, string, this.getPrivacyListItems(string));
            ++n;
        }
        return privacyListArray;
    }

    public void setActiveListName(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = new Privacy();
        privacy.setActiveName(string);
        this.setRequest(privacy);
    }

    public void declineActiveList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = new Privacy();
        privacy.setDeclineActiveList(true);
        this.setRequest(privacy);
    }

    public void setDefaultListName(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = new Privacy();
        privacy.setDefaultName(string);
        this.setRequest(privacy);
    }

    public void declineDefaultList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = new Privacy();
        privacy.setDeclineDefaultList(true);
        this.setRequest(privacy);
    }

    public void createPrivacyList(String string, List<PrivacyItem> list) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.updatePrivacyList(string, list);
    }

    public void updatePrivacyList(String string, List<PrivacyItem> list) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, list);
        this.setRequest(privacy);
    }

    public void deletePrivacyList(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, new ArrayList<PrivacyItem>());
        this.setRequest(privacy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PrivacyListListener privacyListListener) {
        List<PrivacyListListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(privacyListListener);
        }
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(this.connection().getServiceName(), NAMESPACE);
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                PrivacyListManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

