/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;

public class SubscriptionsExtension
extends NodeExtension {
    protected List<Subscription> items = Collections.emptyList();

    public SubscriptionsExtension(List<Subscription> list) {
        super(PubSubElementType.SUBSCRIPTIONS);
        if (list != null) {
            this.items = list;
        }
    }

    public SubscriptionsExtension(String string, List<Subscription> list) {
        super(PubSubElementType.SUBSCRIPTIONS, string);
        if (list != null) {
            this.items = list;
        }
    }

    public List<Subscription> getSubscriptions() {
        return this.items;
    }

    @Override
    public CharSequence toXML() {
        if (this.items == null || this.items.size() == 0) {
            return super.toXML();
        }
        StringBuilder stringBuilder = new StringBuilder("<");
        stringBuilder.append(this.getElementName());
        if (this.getNode() != null) {
            stringBuilder.append(" node='");
            stringBuilder.append(this.getNode());
            stringBuilder.append("'");
        }
        stringBuilder.append(">");
        for (Subscription subscription : this.items) {
            stringBuilder.append(subscription.toXML());
        }
        stringBuilder.append("</");
        stringBuilder.append(this.getElementName());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

