/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;

public class DeliveryReceiptManager
extends Manager
implements PacketListener {
    private static Map<XMPPConnection, DeliveryReceiptManager> instances = new WeakHashMap<XMPPConnection, DeliveryReceiptManager>();
    private boolean auto_receipts_enabled = false;
    private Set<ReceiptReceivedListener> receiptReceivedListeners = Collections.synchronizedSet(new HashSet());

    private DeliveryReceiptManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        serviceDiscoveryManager.addFeature("urn:xmpp:receipts");
        xMPPConnection.addPacketListener(this, new PacketExtensionFilter("urn:xmpp:receipts"));
    }

    public static synchronized DeliveryReceiptManager getInstanceFor(XMPPConnection xMPPConnection) {
        DeliveryReceiptManager deliveryReceiptManager = instances.get(xMPPConnection);
        if (deliveryReceiptManager == null) {
            deliveryReceiptManager = new DeliveryReceiptManager(xMPPConnection);
            instances.put(xMPPConnection, deliveryReceiptManager);
        }
        return deliveryReceiptManager;
    }

    public boolean isSupported(String string) throws SmackException, XMPPException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(string, "urn:xmpp:receipts");
    }

    @Override
    public void processPacket(Packet packet) throws SmackException.NotConnectedException {
        Object object;
        Object object2;
        DeliveryReceipt deliveryReceipt = DeliveryReceipt.getFrom(packet);
        if (deliveryReceipt != null) {
            object2 = this.receiptReceivedListeners.iterator();
            while (object2.hasNext()) {
                object = (ReceiptReceivedListener)object2.next();
                object.onReceiptReceived(packet.getFrom(), packet.getTo(), deliveryReceipt.getId());
            }
        }
        if (this.auto_receipts_enabled && (object2 = DeliveryReceiptRequest.getFrom(packet)) != null) {
            object = this.connection();
            Message message = new Message(packet.getFrom(), Message.Type.normal);
            message.addExtension(new DeliveryReceipt(packet.getPacketID()));
            ((XMPPConnection)object).sendPacket(message);
        }
    }

    public void setAutoReceiptsEnabled(boolean bl) {
        this.auto_receipts_enabled = bl;
    }

    public void enableAutoReceipts() {
        this.setAutoReceiptsEnabled(true);
    }

    public void disableAutoReceipts() {
        this.setAutoReceiptsEnabled(false);
    }

    public boolean getAutoReceiptsEnabled() {
        return this.auto_receipts_enabled;
    }

    public void addReceiptReceivedListener(ReceiptReceivedListener receiptReceivedListener) {
        this.receiptReceivedListeners.add(receiptReceivedListener);
    }

    public void removeReceiptReceivedListener(ReceiptReceivedListener receiptReceivedListener) {
        this.receiptReceivedListeners.remove(receiptReceivedListener);
    }

    public static boolean hasDeliveryReceiptRequest(Packet packet) {
        return DeliveryReceiptRequest.getFrom(packet) != null;
    }

    public static String addDeliveryReceiptRequest(Message message) {
        message.addExtension(new DeliveryReceiptRequest());
        return message.getPacketID();
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                DeliveryReceiptManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

