/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class ReportedData {
    private List<Column> columns = new ArrayList<Column>();
    private List<Row> rows = new ArrayList<Row>();
    private String title = "";

    public static ReportedData getReportedDataFrom(Packet packet) {
        DataForm dataForm;
        Object PE = packet.getExtension("x", "jabber:x:data");
        if (PE != null && (dataForm = (DataForm)PE).getReportedData() != null) {
            return new ReportedData(dataForm);
        }
        return null;
    }

    private ReportedData(DataForm dataForm) {
        for (FormField object : dataForm.getReportedData().getFields()) {
            this.columns.add(new Column(object.getLabel(), object.getVariable(), object.getType()));
        }
        for (DataForm.Item item : dataForm.getItems()) {
            ArrayList<Field> arrayList = new ArrayList<Field>(this.columns.size());
            for (FormField formField : item.getFields()) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string : formField.getValues()) {
                    arrayList2.add(string);
                }
                arrayList.add(new Field(formField.getVariable(), arrayList2));
            }
            this.rows.add(new Row(arrayList));
        }
        this.title = dataForm.getTitle();
    }

    public ReportedData() {
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public List<Row> getRows() {
        return Collections.unmodifiableList(new ArrayList<Row>(this.rows));
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(new ArrayList<Column>(this.columns));
    }

    public String getTitle() {
        return this.title;
    }

    public static class Field {
        private String variable;
        private List<String> values;

        public Field(String string, List<String> list) {
            this.variable = string;
            this.values = list;
        }

        public String getVariable() {
            return this.variable;
        }

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }
    }

    public static class Row {
        private List<Field> fields = new ArrayList<Field>();

        public Row(List<Field> list) {
            this.fields = list;
        }

        public List<String> getValues(String string) {
            for (Field field : this.getFields()) {
                if (!string.equalsIgnoreCase(field.getVariable())) continue;
                return field.getValues();
            }
            return null;
        }

        private List<Field> getFields() {
            return Collections.unmodifiableList(new ArrayList<Field>(this.fields));
        }
    }

    public static class Column {
        private String label;
        private String variable;
        private String type;

        public Column(String string, String string2, String string3) {
            this.label = string;
            this.variable = string2;
            this.type = string3;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

