/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.SimpleUserSearch;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.xmlpull.v1.XmlPullParser;

public class UserSearch
extends IQ {
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:search\">");
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }

    public Form getSearchForm(XMPPConnection xMPPConnection, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        UserSearch userSearch = new UserSearch();
        userSearch.setType(IQ.Type.GET);
        userSearch.setTo(string);
        IQ iQ = (IQ)xMPPConnection.createPacketCollectorAndSend(userSearch).nextResultOrThrow();
        return Form.getFormFrom(iQ);
    }

    public ReportedData sendSearchForm(XMPPConnection xMPPConnection, Form form, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        UserSearch userSearch = new UserSearch();
        userSearch.setType(IQ.Type.SET);
        userSearch.setTo(string);
        userSearch.addExtension(form.getDataFormToSend());
        IQ iQ = (IQ)xMPPConnection.createPacketCollectorAndSend(userSearch).nextResultOrThrow();
        return ReportedData.getReportedDataFrom(iQ);
    }

    public ReportedData sendSimpleSearchForm(XMPPConnection xMPPConnection, Form form, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
        simpleUserSearch.setForm(form);
        simpleUserSearch.setType(IQ.Type.SET);
        simpleUserSearch.setTo(string);
        SimpleUserSearch simpleUserSearch2 = (SimpleUserSearch)xMPPConnection.createPacketCollectorAndSend(simpleUserSearch).nextResultOrThrow();
        return simpleUserSearch2.getReportedData();
    }

    private static void buildDataForm(SimpleUserSearch simpleUserSearch, String string, XmlPullParser xmlPullParser) throws Exception {
        DataForm dataForm = new DataForm("form");
        boolean bl = false;
        dataForm.setTitle("User Search");
        dataForm.addInstruction(string);
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2 && !xmlPullParser.getNamespace().equals("jabber:x:data")) {
                String string2 = xmlPullParser.getName();
                FormField formField = new FormField(string2);
                if (string2.equals("first")) {
                    formField.setLabel("First Name");
                } else if (string2.equals("last")) {
                    formField.setLabel("Last Name");
                } else if (string2.equals("email")) {
                    formField.setLabel("Email Address");
                } else if (string2.equals("nick")) {
                    formField.setLabel("Nickname");
                }
                formField.setType("text-single");
                dataForm.addField(formField);
                continue;
            }
            if (n == 3) {
                if (!xmlPullParser.getName().equals("query")) continue;
                bl = true;
                continue;
            }
            if (n != 2 || !xmlPullParser.getNamespace().equals("jabber:x:data")) continue;
            simpleUserSearch.addExtension(PacketParserUtils.parsePacketExtension(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser));
            bl = true;
        }
        if (simpleUserSearch.getExtension("x", "jabber:x:data") == null) {
            simpleUserSearch.addExtension(dataForm);
        }
    }

    public static class Provider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            UserSearch userSearch = null;
            SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && xmlPullParser.getName().equals("instructions")) {
                    UserSearch.buildDataForm(simpleUserSearch, xmlPullParser.nextText(), xmlPullParser);
                    return simpleUserSearch;
                }
                if (n == 2 && xmlPullParser.getName().equals("item")) {
                    simpleUserSearch.parseItems(xmlPullParser);
                    return simpleUserSearch;
                }
                if (n == 2 && xmlPullParser.getNamespace().equals("jabber:x:data")) {
                    userSearch = new UserSearch();
                    userSearch.addExtension(PacketParserUtils.parsePacketExtension(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser));
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
                bl = true;
            }
            if (userSearch != null) {
                return userSearch;
            }
            return simpleUserSearch;
        }
    }
}

