/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.UserSearch;
import org.jivesoftware.smackx.xdata.Form;

public class UserSearchManager {
    private XMPPConnection con;
    private UserSearch userSearch;

    public UserSearchManager(XMPPConnection xMPPConnection) {
        this.con = xMPPConnection;
        this.userSearch = new UserSearch();
    }

    public Form getSearchForm(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.userSearch.getSearchForm(this.con, string);
    }

    public ReportedData getSearchResults(Form form, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.userSearch.sendSearchForm(this.con, form, string);
    }

    public Collection<String> getSearchServices() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.con);
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(this.con.getServiceName());
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            try {
                DiscoverInfo discoverInfo;
                try {
                    discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
                }
                catch (XMPPException xMPPException) {
                    continue;
                }
                if (!discoverInfo.containsFeature("jabber:iq:search")) continue;
                arrayList.add(item.getEntityID());
            }
            catch (Exception exception) {
                break;
            }
        }
        return arrayList;
    }
}

