/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.time.packet.Time;

public class EntityTimeManager
extends Manager {
    private static final Map<XMPPConnection, EntityTimeManager> INSTANCES = new WeakHashMap<XMPPConnection, EntityTimeManager>();
    private static final PacketFilter TIME_PACKET_FILTER = new AndFilter(new PacketTypeFilter(Time.class), new IQTypeFilter(IQ.Type.GET));
    private static boolean autoEnable = true;
    private boolean enabled = false;

    public static void setAutoEnable(boolean bl) {
        autoEnable = bl;
    }

    public static synchronized EntityTimeManager getInstanceFor(XMPPConnection xMPPConnection) {
        EntityTimeManager entityTimeManager = INSTANCES.get(xMPPConnection);
        if (entityTimeManager == null) {
            entityTimeManager = new EntityTimeManager(xMPPConnection);
        }
        return entityTimeManager;
    }

    private EntityTimeManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        INSTANCES.put(xMPPConnection, this);
        if (autoEnable) {
            this.enable();
        }
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                if (!EntityTimeManager.this.enabled) {
                    return;
                }
                EntityTimeManager.this.connection().sendPacket(Time.createResponse(packet));
            }
        }, TIME_PACKET_FILTER);
    }

    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        serviceDiscoveryManager.addFeature("urn:xmpp:time");
        this.enabled = true;
    }

    public synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        serviceDiscoveryManager.removeFeature("urn:xmpp:time");
        this.enabled = false;
    }

    public boolean isTimeSupported(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(string, "urn:xmpp:time");
    }

    public Time getTime(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!this.isTimeSupported(string)) {
            return null;
        }
        Time time = new Time();
        Time time2 = (Time)this.connection().createPacketCollectorAndSend(time).nextResultOrThrow();
        return time2;
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                EntityTimeManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

