/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim;

import org.jivesoftware.smack.util.StringUtils;

public class XHTMLText {
    private static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    private StringBuilder text = new StringBuilder(30);

    public XHTMLText(String string, String string2) {
        this.appendOpenBodyTag(string, string2);
    }

    public void appendOpenAnchorTag(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("<a");
        if (string != null) {
            stringBuilder.append(" href=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        if (string2 != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendCloseAnchorTag() {
        this.text.append("</a>");
    }

    public void appendOpenBlockQuoteTag(String string) {
        StringBuilder stringBuilder = new StringBuilder("<blockquote");
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendCloseBlockQuoteTag() {
        this.text.append("</blockquote>");
    }

    private void appendOpenBodyTag(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("<body xmlns=\"http://www.w3.org/1999/xhtml\"");
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        if (string2 != null) {
            stringBuilder.append(" xml:lang=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    private String closeBodyTag() {
        return "</body>";
    }

    public void appendBrTag() {
        this.text.append("<br/>");
    }

    public void appendOpenCiteTag() {
        this.text.append("<cite>");
    }

    public void appendOpenCodeTag() {
        this.text.append("<code>");
    }

    public void appendCloseCodeTag() {
        this.text.append("</code>");
    }

    public void appendOpenEmTag() {
        this.text.append("<em>");
    }

    public void appendCloseEmTag() {
        this.text.append("</em>");
    }

    public void appendOpenHeaderTag(int n, String string) {
        if (n > 3 || n < 1) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("<h");
        stringBuilder.append(n);
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendCloseHeaderTag(int n) {
        if (n > 3 || n < 1) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("</h");
        stringBuilder.append(n);
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendImageTag(String string, String string2, String string3, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder("<img");
        if (string != null) {
            stringBuilder.append(" align=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        if (string2 != null) {
            stringBuilder.append(" alt=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        if (string3 != null) {
            stringBuilder.append(" height=\"");
            stringBuilder.append(string3);
            stringBuilder.append("\"");
        }
        if (string4 != null) {
            stringBuilder.append(" src=\"");
            stringBuilder.append(string4);
            stringBuilder.append("\"");
        }
        if (string5 != null) {
            stringBuilder.append(" width=\"");
            stringBuilder.append(string5);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendLineItemTag(String string) {
        StringBuilder stringBuilder = new StringBuilder("<li");
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendOpenOrderedListTag(String string) {
        StringBuilder stringBuilder = new StringBuilder("<ol");
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendCloseOrderedListTag() {
        this.text.append("</ol>");
    }

    public void appendOpenUnorderedListTag(String string) {
        StringBuilder stringBuilder = new StringBuilder("<ul");
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendCloseUnorderedListTag() {
        this.text.append("</ul>");
    }

    public void appendOpenParagraphTag(String string) {
        StringBuilder stringBuilder = new StringBuilder("<p");
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendCloseParagraphTag() {
        this.text.append("</p>");
    }

    public void appendOpenInlinedQuoteTag(String string) {
        StringBuilder stringBuilder = new StringBuilder("<q");
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendCloseInlinedQuoteTag() {
        this.text.append("</q>");
    }

    public void appendOpenSpanTag(String string) {
        StringBuilder stringBuilder = new StringBuilder("<span");
        if (string != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        this.text.append(stringBuilder.toString());
    }

    public void appendCloseSpanTag() {
        this.text.append("</span>");
    }

    public void appendOpenStrongTag() {
        this.text.append("<strong>");
    }

    public void appendCloseStrongTag() {
        this.text.append("</strong>");
    }

    public void append(String string) {
        this.text.append(StringUtils.escapeForXML(string));
    }

    public String toString() {
        return this.text.toString().concat(this.closeBodyTag());
    }
}

