/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils;

import android.text.TextUtils;
import com.lidroid.xutils.exception.HttpException;
import com.lidroid.xutils.http.HttpCache;
import com.lidroid.xutils.http.HttpHandler;
import com.lidroid.xutils.http.RequestParams;
import com.lidroid.xutils.http.ResponseStream;
import com.lidroid.xutils.http.SyncHttpHandler;
import com.lidroid.xutils.http.callback.HttpRedirectHandler;
import com.lidroid.xutils.http.callback.RequestCallBack;
import com.lidroid.xutils.http.client.HttpRequest;
import com.lidroid.xutils.http.client.RetryHandler;
import com.lidroid.xutils.http.client.entity.GZipDecompressingEntity;
import com.lidroid.xutils.util.core.SimpleSSLSocketFactory;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpUtils {
    public static final HttpCache sHttpCache = new HttpCache();
    private final DefaultHttpClient httpClient;
    private final HttpContext httpContext = new BasicHttpContext();
    private HttpRedirectHandler httpRedirectHandler;
    private String responseTextCharset = "UTF-8";
    private long currentRequestExpiry = HttpCache.getDefaultExpiryTime();
    private static final int DEFAULT_CONN_TIMEOUT = 15000;
    private static final int DEFAULT_RETRY_TIMES = 5;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "HttpUtils #" + this.mCount.getAndIncrement());
            thread.setPriority(4);
            return thread;
        }
    };
    private static int threadPoolSize = 3;
    private static Executor executor = Executors.newFixedThreadPool(threadPoolSize, sThreadFactory);

    public HttpUtils() {
        this(15000);
    }

    public HttpUtils(int connTimeout) {
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)params, (long)connTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)connTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(10));
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)10);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SimpleSSLSocketFactory.getSocketFactory(), 443));
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry), (HttpParams)params);
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(5));
        this.httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(org.apache.http.HttpRequest httpRequest, HttpContext httpContext) throws org.apache.http.HttpException, IOException {
                if (!httpRequest.containsHeader(HttpUtils.HEADER_ACCEPT_ENCODING)) {
                    httpRequest.addHeader(HttpUtils.HEADER_ACCEPT_ENCODING, HttpUtils.ENCODING_GZIP);
                }
            }
        });
        this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext httpContext) throws org.apache.http.HttpException, IOException {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return;
                }
                Header encoding = entity.getContentEncoding();
                if (encoding != null) {
                    HeaderElement[] headerElementArray = encoding.getElements();
                    int n = headerElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HeaderElement element = headerElementArray[n2];
                        if (element.getName().equalsIgnoreCase(HttpUtils.ENCODING_GZIP)) {
                            response.setEntity((HttpEntity)new GZipDecompressingEntity(response.getEntity()));
                            return;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpUtils configResponseTextCharset(String charSet) {
        if (!TextUtils.isEmpty((CharSequence)charSet)) {
            this.responseTextCharset = charSet;
        }
        return this;
    }

    public HttpUtils configHttpRedirectHandler(HttpRedirectHandler httpRedirectHandler) {
        this.httpRedirectHandler = httpRedirectHandler;
        return this;
    }

    public HttpUtils configHttpCacheSize(int httpCacheSize) {
        sHttpCache.setCacheSize(httpCacheSize);
        return this;
    }

    public HttpUtils configDefaultHttpCacheExpiry(long defaultExpiry) {
        HttpCache.setDefaultExpiryTime(defaultExpiry);
        this.currentRequestExpiry = HttpCache.getDefaultExpiryTime();
        return this;
    }

    public HttpUtils configCurrentHttpCacheExpiry(long currRequestExpiry) {
        this.currentRequestExpiry = currRequestExpiry;
        return this;
    }

    public HttpUtils configCookieStore(CookieStore cookieStore) {
        this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        return this;
    }

    public HttpUtils configUserAgent(String userAgent) {
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)userAgent);
        return this;
    }

    public HttpUtils configTimeout(int timeout) {
        HttpParams httpParams = this.httpClient.getParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeout);
        return this;
    }

    public HttpUtils configRegisterScheme(Scheme scheme) {
        this.httpClient.getConnectionManager().getSchemeRegistry().register(scheme);
        return this;
    }

    public HttpUtils configSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        Scheme scheme = new Scheme("https", (SocketFactory)sslSocketFactory, 443);
        this.httpClient.getConnectionManager().getSchemeRegistry().register(scheme);
        return this;
    }

    public HttpUtils configRequestRetryCount(int count) {
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(count));
        return this;
    }

    public HttpUtils configRequestThreadPoolSize(int threadPoolSize) {
        if (threadPoolSize > 0 && threadPoolSize != HttpUtils.threadPoolSize) {
            HttpUtils.threadPoolSize = threadPoolSize;
            executor = Executors.newFixedThreadPool(threadPoolSize, sThreadFactory);
        }
        return this;
    }

    public <T> HttpHandler<T> send(HttpRequest.HttpMethod method, String url, RequestCallBack<T> callBack) {
        return this.send(method, url, null, callBack);
    }

    public <T> HttpHandler<T> send(HttpRequest.HttpMethod method, String url, RequestParams params, RequestCallBack<T> callBack) {
        if (url == null) {
            throw new IllegalArgumentException("url may not be null");
        }
        HttpRequest request = new HttpRequest(method, url);
        return this.sendRequest(request, params, callBack);
    }

    public ResponseStream sendSync(HttpRequest.HttpMethod method, String url) throws HttpException {
        return this.sendSync(method, url, null);
    }

    public ResponseStream sendSync(HttpRequest.HttpMethod method, String url, RequestParams params) throws HttpException {
        if (url == null) {
            throw new IllegalArgumentException("url may not be null");
        }
        HttpRequest request = new HttpRequest(method, url);
        return this.sendSyncRequest(request, params);
    }

    public HttpHandler<File> download(String url, String target, RequestCallBack<File> callback) {
        return this.download(HttpRequest.HttpMethod.GET, url, target, null, false, false, callback);
    }

    public HttpHandler<File> download(String url, String target, boolean autoResume, RequestCallBack<File> callback) {
        return this.download(HttpRequest.HttpMethod.GET, url, target, null, autoResume, false, callback);
    }

    public HttpHandler<File> download(String url, String target, boolean autoResume, boolean autoRename, RequestCallBack<File> callback) {
        return this.download(HttpRequest.HttpMethod.GET, url, target, null, autoResume, autoRename, callback);
    }

    public HttpHandler<File> download(String url, String target, RequestParams params, RequestCallBack<File> callback) {
        return this.download(HttpRequest.HttpMethod.GET, url, target, params, false, false, callback);
    }

    public HttpHandler<File> download(String url, String target, RequestParams params, boolean autoResume, RequestCallBack<File> callback) {
        return this.download(HttpRequest.HttpMethod.GET, url, target, params, autoResume, false, callback);
    }

    public HttpHandler<File> download(String url, String target, RequestParams params, boolean autoResume, boolean autoRename, RequestCallBack<File> callback) {
        return this.download(HttpRequest.HttpMethod.GET, url, target, params, autoResume, autoRename, callback);
    }

    public HttpHandler<File> download(HttpRequest.HttpMethod method, String url, String target, RequestParams params, RequestCallBack<File> callback) {
        return this.download(method, url, target, params, false, false, callback);
    }

    public HttpHandler<File> download(HttpRequest.HttpMethod method, String url, String target, RequestParams params, boolean autoResume, RequestCallBack<File> callback) {
        return this.download(method, url, target, params, autoResume, false, callback);
    }

    public HttpHandler<File> download(HttpRequest.HttpMethod method, String url, String target, RequestParams params, boolean autoResume, boolean autoRename, RequestCallBack<File> callback) {
        if (url == null) {
            throw new IllegalArgumentException("url may not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target may not be null");
        }
        HttpRequest request = new HttpRequest(method, url);
        HttpHandler<File> handler = new HttpHandler<File>((AbstractHttpClient)this.httpClient, this.httpContext, this.responseTextCharset, callback);
        handler.setExpiry(this.currentRequestExpiry);
        handler.setHttpRedirectHandler(this.httpRedirectHandler);
        request.setRequestParams(params, handler);
        handler.executeOnExecutor(executor, new Object[]{request, target, autoResume, autoRename});
        return handler;
    }

    private <T> HttpHandler<T> sendRequest(HttpRequest request, RequestParams params, RequestCallBack<T> callBack) {
        HttpHandler<T> handler = new HttpHandler<T>((AbstractHttpClient)this.httpClient, this.httpContext, this.responseTextCharset, callBack);
        handler.setExpiry(this.currentRequestExpiry);
        handler.setHttpRedirectHandler(this.httpRedirectHandler);
        request.setRequestParams(params, handler);
        handler.executeOnExecutor(executor, new Object[]{request});
        return handler;
    }

    private ResponseStream sendSyncRequest(HttpRequest request, RequestParams params) throws HttpException {
        SyncHttpHandler handler = new SyncHttpHandler((AbstractHttpClient)this.httpClient, this.httpContext, this.responseTextCharset);
        handler.setExpiry(this.currentRequestExpiry);
        handler.setHttpRedirectHandler(this.httpRedirectHandler);
        request.setRequestParams(params);
        return handler.sendRequest(request);
    }
}

