/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.view;

import android.preference.Preference;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.ExpandableListView;
import android.widget.RadioGroup;
import android.widget.SeekBar;
import android.widget.TabHost;
import com.lidroid.xutils.util.LogUtils;
import com.lidroid.xutils.util.core.DoubleKeyValueMap;
import com.lidroid.xutils.view.ViewFinder;
import com.lidroid.xutils.view.ViewInjectInfo;
import com.lidroid.xutils.view.annotation.event.OnCheckedChange;
import com.lidroid.xutils.view.annotation.event.OnChildClick;
import com.lidroid.xutils.view.annotation.event.OnClick;
import com.lidroid.xutils.view.annotation.event.OnFocusChange;
import com.lidroid.xutils.view.annotation.event.OnGroupClick;
import com.lidroid.xutils.view.annotation.event.OnGroupCollapse;
import com.lidroid.xutils.view.annotation.event.OnGroupExpand;
import com.lidroid.xutils.view.annotation.event.OnItemClick;
import com.lidroid.xutils.view.annotation.event.OnItemLongClick;
import com.lidroid.xutils.view.annotation.event.OnItemSelected;
import com.lidroid.xutils.view.annotation.event.OnKey;
import com.lidroid.xutils.view.annotation.event.OnLongClick;
import com.lidroid.xutils.view.annotation.event.OnNothingSelected;
import com.lidroid.xutils.view.annotation.event.OnPreferenceChange;
import com.lidroid.xutils.view.annotation.event.OnPreferenceClick;
import com.lidroid.xutils.view.annotation.event.OnProgressChanged;
import com.lidroid.xutils.view.annotation.event.OnScroll;
import com.lidroid.xutils.view.annotation.event.OnScrollChanged;
import com.lidroid.xutils.view.annotation.event.OnScrollStateChanged;
import com.lidroid.xutils.view.annotation.event.OnStartTrackingTouch;
import com.lidroid.xutils.view.annotation.event.OnStopTrackingTouch;
import com.lidroid.xutils.view.annotation.event.OnTabChange;
import com.lidroid.xutils.view.annotation.event.OnTouch;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class ViewCommonEventListener
implements View.OnClickListener,
View.OnLongClickListener,
View.OnFocusChangeListener,
View.OnKeyListener,
View.OnTouchListener,
AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener,
ExpandableListView.OnChildClickListener,
ExpandableListView.OnGroupClickListener,
ExpandableListView.OnGroupCollapseListener,
ExpandableListView.OnGroupExpandListener,
RadioGroup.OnCheckedChangeListener,
CompoundButton.OnCheckedChangeListener,
Preference.OnPreferenceClickListener,
Preference.OnPreferenceChangeListener,
TabHost.OnTabChangeListener,
ViewTreeObserver.OnScrollChangedListener,
AbsListView.OnScrollListener,
AdapterView.OnItemSelectedListener,
SeekBar.OnSeekBarChangeListener {
    private final Object handler;
    private final Method[] methods;

    public ViewCommonEventListener(Object handler, Method ... methods) {
        this.handler = handler;
        this.methods = methods;
    }

    public void onClick(View v) {
        try {
            this.methods[0].invoke(this.handler, v);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public boolean onLongClick(View v) {
        try {
            return (Boolean)this.methods[0].invoke(this.handler, v);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return false;
        }
    }

    public void onFocusChange(View view, boolean b) {
        try {
            this.methods[0].invoke(this.handler, view, b);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public boolean onKey(View view, int i, KeyEvent keyEvent) {
        try {
            return (Boolean)this.methods[0].invoke(this.handler, view, i, keyEvent);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return false;
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        try {
            return (Boolean)this.methods[0].invoke(this.handler, view, motionEvent);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return false;
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        try {
            this.methods[0].invoke(this.handler, parent, view, position, id);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
        try {
            return (Boolean)this.methods[0].invoke(this.handler, parent, view, position, id);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return false;
        }
    }

    public boolean onChildClick(ExpandableListView expandableListView, View view, int i, int i2, long l) {
        try {
            return (Boolean)this.methods[0].invoke(this.handler, expandableListView, view, i, i2, l);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return false;
        }
    }

    public boolean onGroupClick(ExpandableListView expandableListView, View view, int i, long l) {
        try {
            return (Boolean)this.methods[0].invoke(this.handler, expandableListView, view, i, l);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return false;
        }
    }

    public void onGroupCollapse(int i) {
        try {
            this.methods[0].invoke(this.handler, i);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onGroupExpand(int i) {
        try {
            this.methods[0].invoke(this.handler, i);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onCheckedChanged(RadioGroup group, int checkedId) {
        try {
            this.methods[0].invoke(this.handler, group, checkedId);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        try {
            this.methods[0].invoke(this.handler, buttonView, isChecked);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public boolean onPreferenceClick(Preference preference) {
        try {
            return (Boolean)this.methods[0].invoke(this.handler, preference);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return false;
        }
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        try {
            return (Boolean)this.methods[0].invoke(this.handler, preference, newValue);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return false;
        }
    }

    public void onTabChanged(String tabId) {
        try {
            this.methods[0].invoke(this.handler, tabId);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onScrollChanged() {
        try {
            this.methods[0].invoke(this.handler, new Object[0]);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onScrollStateChanged(AbsListView absListView, int i) {
        try {
            this.methods[0].invoke(this.handler, absListView, i);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onScroll(AbsListView absListView, int i, int i2, int i3) {
        if (this.methods.length < 2 || this.methods[1] == null) {
            LogUtils.w("onScroll not implement");
            return;
        }
        try {
            this.methods[1].invoke(this.handler, absListView, i, i2, i3);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        try {
            this.methods[0].invoke(this.handler, parent, view, position, id);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onNothingSelected(AdapterView<?> parent) {
        if (this.methods.length < 2 || this.methods[1] == null) {
            LogUtils.w("onNothingSelected not implement");
            return;
        }
        try {
            this.methods[1].invoke(this.handler, parent);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        try {
            this.methods[0].invoke(this.handler, seekBar, progress, fromUser);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        if (this.methods.length < 2 || this.methods[1] == null) {
            LogUtils.w("onStartTrackingTouch not implement");
            return;
        }
        try {
            this.methods[1].invoke(this.handler, seekBar);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.methods.length < 3 || this.methods[2] == null) {
            LogUtils.w("onStopTrackingTouch not implement");
            return;
        }
        try {
            this.methods[2].invoke(this.handler, seekBar);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public static void setAllEventListeners(Object handler, ViewFinder finder, DoubleKeyValueMap<ViewInjectInfo, Annotation, Method> info_annotation_method_map) {
        block2: for (ViewInjectInfo info : info_annotation_method_map.getFirstKeys()) {
            ConcurrentHashMap<Annotation, Method> annotation_method_map = info_annotation_method_map.get(info);
            for (Annotation annotation : annotation_method_map.keySet()) {
                try {
                    ViewCommonEventListener listener;
                    ConcurrentHashMap<Annotation, Method> a_m_map;
                    Method method1;
                    Method method0;
                    Preference preference;
                    ViewCommonEventListener listener2;
                    View view;
                    Method method = annotation_method_map.get(annotation);
                    if (annotation instanceof OnClick) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnClickListener", View.OnClickListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnLongClick) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnLongClickListener", View.OnLongClickListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnFocusChange) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnFocusChangeListener", View.OnFocusChangeListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnKey) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnKeyListener", View.OnKeyListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnTouch) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnTouchListener", View.OnTouchListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnItemClick) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnItemClickListener", AdapterView.OnItemClickListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnItemLongClick) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnItemLongClickListener", AdapterView.OnItemLongClickListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnChildClick) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnChildClickListener", ExpandableListView.OnChildClickListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnGroupClick) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnGroupClickListener", ExpandableListView.OnGroupClickListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnGroupCollapse) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnGroupCollapseListener", ExpandableListView.OnGroupCollapseListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnGroupExpand) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnGroupExpandListener", ExpandableListView.OnGroupExpandListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnCheckedChange) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        if (view instanceof RadioGroup) {
                            listener2 = new ViewCommonEventListener(handler, method);
                            ViewCommonEventListener.setEventListener(view, "setOnCheckedChangeListener", RadioGroup.OnCheckedChangeListener.class, listener2);
                            continue;
                        }
                        if (!(view instanceof CompoundButton)) continue;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnCheckedChangeListener", CompoundButton.OnCheckedChangeListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnPreferenceClick) {
                        preference = finder.findPreference(info.value.toString());
                        if (preference == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(preference, "setOnPreferenceClickListener", Preference.OnPreferenceClickListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnPreferenceChange) {
                        preference = finder.findPreference(info.value.toString());
                        if (preference == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(preference, "setOnPreferenceChangeListener", Preference.OnPreferenceChangeListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnTabChange) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "setOnTabChangedListener", TabHost.OnTabChangeListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnScrollChanged) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        listener2 = new ViewCommonEventListener(handler, method);
                        ViewCommonEventListener.setEventListener(view, "addOnScrollChangedListener", ViewTreeObserver.OnScrollChangedListener.class, listener2);
                        continue;
                    }
                    if (annotation instanceof OnScrollStateChanged) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        method0 = null;
                        method1 = null;
                        a_m_map = info_annotation_method_map.get(info);
                        for (Annotation a : a_m_map.keySet()) {
                            if (a instanceof OnScrollStateChanged) {
                                method0 = a_m_map.get(a);
                                continue;
                            }
                            if (!(a instanceof OnScroll)) continue;
                            method1 = a_m_map.get(a);
                        }
                        listener = new ViewCommonEventListener(handler, method0, method1);
                        ViewCommonEventListener.setEventListener(view, "setOnScrollListener", AbsListView.OnScrollListener.class, listener);
                        continue;
                    }
                    if (annotation instanceof OnItemSelected) {
                        view = finder.findViewByInfo(info);
                        if (view == null) continue block2;
                        method0 = null;
                        method1 = null;
                        a_m_map = info_annotation_method_map.get(info);
                        for (Annotation a : a_m_map.keySet()) {
                            if (a instanceof OnItemSelected) {
                                method0 = a_m_map.get(a);
                                continue;
                            }
                            if (!(a instanceof OnNothingSelected)) continue;
                            method1 = a_m_map.get(a);
                        }
                        listener = new ViewCommonEventListener(handler, method0, method1);
                        ViewCommonEventListener.setEventListener(view, "setOnItemSelectedListener", AdapterView.OnItemSelectedListener.class, listener);
                        continue;
                    }
                    if (!(annotation instanceof OnProgressChanged)) continue;
                    view = finder.findViewByInfo(info);
                    if (view == null) continue block2;
                    method0 = null;
                    method1 = null;
                    Method method2 = null;
                    ConcurrentHashMap<Annotation, Method> a_m_map2 = info_annotation_method_map.get(info);
                    for (Annotation a : a_m_map2.keySet()) {
                        if (a instanceof OnProgressChanged) {
                            method0 = a_m_map2.get(a);
                            continue;
                        }
                        if (a instanceof OnStartTrackingTouch) {
                            method1 = a_m_map2.get(a);
                            continue;
                        }
                        if (!(a instanceof OnStopTrackingTouch)) continue;
                        method2 = a_m_map2.get(a);
                    }
                    ViewCommonEventListener listener3 = new ViewCommonEventListener(handler, method0, method1, method2);
                    ViewCommonEventListener.setEventListener(view, "setOnSeekBarChangeListener", SeekBar.OnSeekBarChangeListener.class, listener3);
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
    }

    private static void setEventListener(Object view, String setEventListenerMethod, Class<?> eventListenerType, ViewCommonEventListener listener) {
        try {
            Method setMethod = view.getClass().getMethod(setEventListenerMethod, eventListenerType);
            if (setMethod != null) {
                setMethod.invoke(view, listener);
            }
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }
}

