/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.view.View;
import com.baidu.mapapi.BMapManager;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.platform.comapi.AssetsLoadUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BitmapDescriptorFactory {
    public static BitmapDescriptor fromAsset(String string) {
        Context context = BMapManager.getContext();
        if (context == null) {
            return null;
        }
        try {
            Bitmap bitmap = AssetsLoadUtil.loadAssetsFile(string, context);
            BitmapDescriptor bitmapDescriptor = null;
            bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            assert (bitmap != null);
            bitmap.recycle();
            return bitmapDescriptor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BitmapDescriptor fromAssetWithDpi(String string) {
        Context context = BMapManager.getContext();
        if (context == null) {
            return null;
        }
        try {
            Bitmap bitmap = AssetsLoadUtil.loadAssetsFile(string, context);
            if (bitmap == null) {
                return null;
            }
            Bitmap bitmap2 = null;
            BitmapDescriptor bitmapDescriptor = null;
            int n2 = SysOSUtil.getDensityDpi();
            if (n2 > 480) {
                Matrix matrix = new Matrix();
                matrix.postScale(2.0f, 2.0f);
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap2);
            } else if (n2 > 320 && n2 <= 480) {
                Matrix matrix = new Matrix();
                matrix.postScale(1.5f, 1.5f);
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap2);
            } else {
                bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            }
            bitmap.recycle();
            if (bitmap2 != null) {
                bitmap2.recycle();
            }
            return bitmapDescriptor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        BitmapDescriptor bitmapDescriptor = new BitmapDescriptor(bitmap);
        return bitmapDescriptor;
    }

    public static BitmapDescriptor fromFile(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            Context context = BMapManager.getContext();
            if (context != null) {
                FileInputStream fileInputStream = context.openFileInput(string);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream);
                fileInputStream.close();
                if (bitmap != null) {
                    BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                    bitmap.recycle();
                    return bitmapDescriptor;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static BitmapDescriptor fromPath(String string) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)string);
        if (bitmap != null && bitmap != null) {
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            bitmap.recycle();
            return bitmapDescriptor;
        }
        return null;
    }

    public static BitmapDescriptor fromResource(int n2) {
        Context context = BMapManager.getContext();
        if (context != null) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
            if (bitmap == null) {
                return null;
            }
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            bitmap.recycle();
            return bitmapDescriptor;
        }
        return null;
    }

    public static BitmapDescriptor fromView(View view) {
        if (view == null) {
            return null;
        }
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
        if (bitmap != null) {
            bitmap.recycle();
        }
        view.destroyDrawingCache();
        return bitmapDescriptor;
    }
}

