/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.facesdk;

import android.content.Context;
import android.content.res.AssetManager;
import com.baidu.idl.facesdk.BDFaceUtils;
import com.baidu.idl.facesdk.FaceInfo;
import com.baidu.idl.facesdk.FaceSDK;
import com.baidu.idl.facesdk.FaceSleepnessInfo;
import com.baidu.idl.facesdk.FaceVerifyData;
import java.util.HashMap;
import java.util.Map;

public class FaceTracker {
    private static final String TAG = FaceTracker.class.getSimpleName();
    private Context context;
    private Map<String, Boolean> abilities = new HashMap<String, Boolean>();
    private long index = 1L;

    public FaceTracker(Context context) {
        if (context != null) {
            this.create();
            if (BDFaceUtils.hasModel(context, "align_model.binary")) {
                this.AlignModelInit(context.getAssets(), "align_model.binary", "", FaceSDK.AlignMethodType.CDNN.ordinal());
                this.abilities.put("align_model.binary", true);
            }
            if (BDFaceUtils.hasModel(context, "facedetect.binary")) {
                this.DetectModelInit(context.getAssets(), "facedetect.binary", FaceSDK.DetectMethodType.CNN.ordinal());
                this.abilities.put("facedetect.binary", true);
            }
            if (BDFaceUtils.hasModel(context, "small_detect.model")) {
                this.DetectModelInit(context.getAssets(), "small_detect.model", FaceSDK.DetectMethodType.NIR.ordinal());
                this.abilities.put("small_detect.model", true);
            }
            if (BDFaceUtils.hasModel(context, "score.binary")) {
                this.ScoreModelInit(context.getAssets(), "score.binary", "", FaceSDK.DetectMethodType.CNN.ordinal());
                this.abilities.put("score.binary", true);
            }
            if (BDFaceUtils.hasModel(context, "blur.binary")) {
                this.imgQualityModelInit(context.getAssets(), "blur.binary", "", FaceSDK.QualityModelType.QUALITY_BLUR.ordinal());
                this.abilities.put("blur.binary", true);
            }
            if (BDFaceUtils.hasModel(context, "occlu.binary")) {
                this.imgQualityModelInit(context.getAssets(), "occlu.binary", "", FaceSDK.QualityModelType.QUALITY_OCCLUSION.ordinal());
                this.abilities.put("occlu.binary", true);
            }
        }
    }

    public void track(int[] img, int rows, int cols, int imgType, int maxTrackObjNum) {
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return;
        }
        this.tracking(img, rows, cols, imgType, maxTrackObjNum);
    }

    public ErrCode faceVerification(int[] img, int rows, int cols, FaceSDK.ImgType imgType, ActionType action) {
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return ErrCode.UNKNOW_TYPE;
        }
        int err_code = this.prepare_data_for_verify(img, rows, cols, imgType.ordinal(), action.ordinal());
        if (err_code == ErrCode.OK.ordinal()) {
            return ErrCode.OK;
        }
        if (err_code > 0) {
            return ErrCode.values()[err_code];
        }
        return ErrCode.UNKNOW_TYPE;
    }

    public ErrCode maxFaceVerification(int[] img, int rows, int cols, FaceSDK.ImgType imgType, ActionType action) {
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return ErrCode.UNKNOW_TYPE;
        }
        int err_code = this.prepare_max_face_data_for_verify(img, rows, cols, imgType.ordinal(), action.ordinal());
        if (err_code == ErrCode.OK.ordinal()) {
            return ErrCode.OK;
        }
        if (err_code > 0) {
            return ErrCode.values()[err_code];
        }
        return ErrCode.UNKNOW_TYPE;
    }

    public native FaceInfo[] get_TrackedFaceInfo();

    public native FaceSleepnessInfo[] get_sleepnessInfo();

    private native int create();

    private native int AlignModelInit(AssetManager var1, String var2, String var3, int var4);

    private native int DetectModelInit(AssetManager var1, String var2, int var3);

    private native int ScoreModelInit(AssetManager var1, String var2, String var3, int var4);

    private native int ParsingModelInit(AssetManager var1, String var2, String var3, int var4);

    private native int imgQualityModelInit(AssetManager var1, String var2, String var3, int var4);

    private native void tracking(int[] var1, int var2, int var3, int var4, int var5);

    public native int set_notFace_thr(float var1);

    public native int set_min_face_size(int var1);

    public native int set_illum_thr(float var1);

    public native int set_blur_thr(float var1);

    public native int set_occlu_thr(float var1);

    @Deprecated
    public native int set_detection_frame_interval(int var1);

    public native int set_AlignMethodType(int var1);

    public native int set_isFineAlign(boolean var1);

    public native int set_isVerifyLive(boolean var1);

    public native int set_isCheckQuality(boolean var1);

    @Deprecated
    public native int set_intervalTime(long var1);

    public native int set_track_by_detection_interval(int var1);

    public native int set_detect_in_video_interval(int var1);

    public native int set_eulur_angle_thr(int var1, int var2, int var3);

    public native int set_cropFaceSize(int var1);

    public native int set_max_reg_img_num(int var1);

    public native int clearTrackedFaces();

    public native int re_collect_reg_imgs();

    public native FaceVerifyData[] get_FaceVerifyData(int var1);

    public native int prepare_data_for_verify(int[] var1, int var2, int var3, int var4, int var5);

    public native int prepare_max_face_data_for_verify(int[] var1, int var2, int var3, int var4, int var5);

    public native int set_DetectMethodType(int var1);

    public native int set_cropFaceEnlargeRatio(float var1);

    public native int setAppType(int var1);

    public static enum ActionType {
        DELETE,
        REGIST,
        VERIFY,
        RECOGNIZE;

    }

    public static enum ErrCode {
        OK,
        PITCH_OUT_OF_DOWN_MAX_RANGE,
        PITCH_OUT_OF_UP_MAX_RANGE,
        YAW_OUT_OF_LEFT_MAX_RANGE,
        YAW_OUT_OF_RIGHT_MAX_RANGE,
        POOR_ILLUMINATION,
        NO_FACE_DETECTED,
        DATA_NOT_READY,
        DATA_HIT_ONE,
        DATA_HIT_LAST,
        IMG_BLURED,
        OCCLUSION_LEFT_EYE,
        OCCLUSION_RIGHT_EYE,
        OCCLUSION_NOSE,
        OCCLUSION_MOUTH,
        OCCLUSION_LEFT_CONTOUR,
        OCCLUSION_RIGHT_CONTOUR,
        OCCLUSION_CHIN_CONTOUR,
        FACE_NOT_COMPLETE,
        UNKNOW_TYPE;

    }
}

