/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.license;

import android.content.Context;
import android.util.Log;
import com.baidu.idl.license.LicenseReaderUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class LicenseReader {
    public static final String TAG = "License-SDK";
    private static final String URL = "https://aip.baidubce.com/public/2.0/license/face-api/app/querydevicelicense";
    private String path;

    LicenseReader() {
    }

    public int init(String path) {
        this.path = path;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] get_local_license(Context context) {
        ArrayList<String> license = null;
        InputStream fis = null;
        try {
            String line;
            BufferedReader br = null;
            InputStreamReader reader = null;
            fis = LicenseReaderUtils.get_local_license_file_inputstream(context, this.path);
            Log.e((String)TAG, (String)("open license file path " + this.path));
            if (null == fis) {
                Log.e((String)TAG, (String)"open license file error.");
                String[] stringArray = null;
                return stringArray;
            }
            reader = new InputStreamReader(fis);
            br = new BufferedReader(reader);
            license = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                Log.e((String)TAG, (String)("readLine " + line));
                license.add(line);
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("license file FileNotFoundException " + this.path));
            e.printStackTrace();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("license file IOException " + this.path));
            e.printStackTrace();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("license file Exception " + this.path + " " + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String[] ret = null;
        if (license != null && license.size() > 0) {
            LicenseReaderUtils.write_license_content(context, this.path, license);
            ret = new String[license.size()];
            int idx = 0;
            Iterator iterator = license.iterator();
            while (iterator.hasNext()) {
                String item;
                ret[idx] = item = (String)iterator.next();
                Log.e((String)TAG, (String)("license file info =" + item));
                ++idx;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] get_remote_license(Context context, String postData) {
        HttpURLConnection conn = null;
        InputStream is = null;
        Object os = null;
        Object pw = null;
        String resultData = "";
        String paramStr = "";
        OutputStream outputStream = null;
        InputStream inputStream = null;
        ByteArrayOutputStream baos = null;
        try {
            if (!"".equals(postData)) {
                JSONObject jsonObject = new JSONObject(postData);
                String alStr = jsonObject.getString("sdk_v");
                String queryStr = jsonObject.getString("query");
                paramStr = String.format("sdk_v=%s&query=%s", alStr, queryStr);
            }
            Log.e((String)TAG, (String)"request get_remote_license =https://aip.baidubce.com/public/2.0/license/face-api/app/querydevicelicense");
            URL url = new URL(URL);
            conn = (HttpURLConnection)url.openConnection();
            System.setProperty("sun.net.client.defaultConnectTimeout", "8000");
            System.setProperty("sun.net.client.defaultReadTimeout", "8000");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            outputStream = conn.getOutputStream();
            outputStream.write(paramStr.getBytes());
            outputStream.flush();
            outputStream.close();
            int responseCode = conn.getResponseCode();
            Log.e((String)TAG, (String)("request code " + responseCode));
            if (200 == responseCode) {
                inputStream = conn.getInputStream();
                byte[] buffer = new byte[1024];
                baos = new ByteArrayOutputStream();
                int len = -1;
                while ((len = inputStream.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
                byte[] b = baos.toByteArray();
                resultData = new String(b, "utf-8");
                baos.flush();
                Log.e((String)TAG, (String)("request data " + resultData));
            }
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)("MalformedURLException " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("IOException " + e.getMessage()));
            e.printStackTrace();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception " + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (baos != null) {
                    baos.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        ArrayList<String> license = null;
        if (resultData.length() > 0) {
            JSONArray json_licenses;
            JSONObject object = null;
            try {
                object = new JSONObject(resultData);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (object != null && (json_licenses = object.optJSONArray("result")) != null && json_licenses.length() > 0) {
                license = new ArrayList<String>();
                for (int i = 0; i < json_licenses.length(); ++i) {
                    String tmp = json_licenses.optString(i);
                    if (tmp == null) continue;
                    license.add(tmp);
                }
            }
        }
        String[] ret = null;
        if (license != null && license.size() > 0) {
            ret = new String[license.size()];
            int idx = 0;
            Iterator iterator = license.iterator();
            while (iterator.hasNext()) {
                String item;
                ret[idx] = item = (String)iterator.next();
                ++idx;
                Log.e((String)TAG, (String)item);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int put_local_license(Context context, String[] license) {
        int ret = 0;
        File file = null;
        file = context.getDir(this.path, 0);
        Log.e((String)TAG, (String)("put_local_license =" + file.getAbsolutePath()));
        if (file != null) {
            file.delete();
        }
        if (file != null && !file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"IOException");
                e.printStackTrace();
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            for (String line : license) {
                fos.write(line.getBytes());
                fos.write(10);
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"FileNotFoundException");
            e.printStackTrace();
            ret = -1;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException");
            e.printStackTrace();
            ret = -1;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception");
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ret = -1;
                }
            }
        }
        return ret;
    }
}

