/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.QQPreferences;
import com.umeng.socialize.handler.UMTencentSSOHandler;
import com.umeng.socialize.media.QZoneShareContent;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import org.json.JSONObject;

public class QZoneSsoHandler
extends UMTencentSSOHandler {
    private QZoneShareContent mShareContent;
    private QQPreferences qqPreferences;
    private static final String TAG = "QZoneSsoHandler";

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.qqPreferences = new QQPreferences(context, SHARE_MEDIA.QQ.toString());
    }

    public boolean share(ShareContent content, UMShareListener listener) {
        if (listener != null) {
            this.mShareListener = listener;
        }
        if (!this.isInstall(this.getConfig())) {
            return false;
        }
        this.mShareContent = new QZoneShareContent(content);
        this.shareToQZone();
        return false;
    }

    private void shareToQZone() {
        Bundle bundle = this.mShareContent.buildParamsQzone();
        bundle.putString("appName", this.getAppName());
        if (this.mShareContent.getisPublish()) {
            this.doPublishToQzone(bundle);
        } else {
            this.defaultQZoneShare(bundle);
        }
    }

    public void deleteAuth(UMAuthListener listener) {
        this.mTencent.logout(this.getContext());
        if (this.qqPreferences != null) {
            this.qqPreferences.delete();
        }
        listener.onComplete(SHARE_MEDIA.QZONE, 1, null);
    }

    private boolean isInstall(PlatformConfig.Platform p) {
        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing() && !this.mTencent.isSupportSSOLogin((Activity)this.mWeakAct.get())) {
            StringBuilder msb = new StringBuilder();
            msb.append("\u8bf7\u5b89\u88c5");
            msb.append("qq");
            msb.append("\u5ba2\u6237\u7aef");
            Log.v((String)msb.toString());
            if (Config.IsToastTip) {
                Toast.makeText((Context)this.getContext(), (CharSequence)msb, (int)1).show();
            }
            return false;
        }
        return true;
    }

    public boolean isSupportAuth() {
        return true;
    }

    public void authorize(UMAuthListener authListener) {
        if (!this.isInstall(this.getConfig())) {
            return;
        }
        this.mAuthListener = authListener;
        this.loginDeal();
    }

    private void loginDeal() {
        Log.i((String)TAG, (String)"QQ oauth login...");
        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
            this.mTencent.login((Activity)this.mWeakAct.get(), "all", this.getAuthlistener(this.mAuthListener));
        }
    }

    private IUiListener getAuthlistener(UMAuthListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                if (e != null) {
                    Log.d((String)QZoneSsoHandler.TAG, (String)("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
                }
                QZoneSsoHandler.this.mAuthListener.onError(SHARE_MEDIA.QQ, 0, new Throwable("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
            }

            public void onCancel() {
                QZoneSsoHandler.this.mAuthListener.onCancel(SHARE_MEDIA.QQ, 0);
            }

            public void onComplete(Object response) {
                String status;
                SocializeUtils.safeCloseDialog((Dialog)QZoneSsoHandler.this.mProgressDialog);
                Bundle values = QZoneSsoHandler.this.parseOauthData(response);
                QZoneSsoHandler.this.qqPreferences.setAuthData(values).commit();
                QZoneSsoHandler.this.initOpenidAndToken((JSONObject)response);
                if (QZoneSsoHandler.this.mAuthListener != null) {
                    QZoneSsoHandler.this.mAuthListener.onComplete(SHARE_MEDIA.QQ, 0, SocializeUtils.bundleTomap((Bundle)values));
                }
                QZoneSsoHandler.this.uploadAuthData(values);
                if (values != null && TextUtils.isEmpty((CharSequence)(status = values.getString("ret")))) {
                    return;
                }
            }
        };
    }

    private void uploadAuthData(final Bundle bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlatformTokenUploadReq req = new PlatformTokenUploadReq(QZoneSsoHandler.this.getContext());
                req.addStringParams("to", "qq");
                req.addStringParams("usid", bundle.getString("uid"));
                req.addStringParams("access_token", bundle.getString("access_token"));
                req.addStringParams("refresh_token", bundle.getString("refresh_token"));
                req.addStringParams("expires_in", bundle.getString("expires_in"));
                req.addStringParams("app_id", QZoneSsoHandler.this.config.appId);
                req.addStringParams("app_secret", QZoneSsoHandler.this.config.appKey);
                PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                Log.e((String)("upload token resp = " + resp));
            }
        }).start();
    }

    public void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString("access_token");
            String expires = jsonObject.getString("expires_in");
            String openId = jsonObject.getString("openid");
            if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                this.mTencent.setAccessToken(token, expires);
                this.mTencent.setOpenId(openId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRequestCode() {
        return 10104;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10104) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getmShareListener(this.mShareListener));
        }
        if (requestCode == 11101) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getAuthlistener(this.mAuthListener));
        }
    }

    public IUiListener getmShareListener(final UMShareListener mShareListener) {
        return new IUiListener(){

            public void onComplete(Object o) {
                if (mShareListener != null) {
                    mShareListener.onResult(SHARE_MEDIA.QZONE);
                }
            }

            public void onError(UiError uiError) {
                if (mShareListener != null) {
                    mShareListener.onError(SHARE_MEDIA.QZONE, new Throwable(uiError.errorMessage));
                }
            }

            public void onCancel() {
                if (mShareListener != null) {
                    mShareListener.onCancel(SHARE_MEDIA.QZONE);
                }
            }
        };
    }

    private void doPublishToQzone(final Bundle bundle) {
        if (bundle != null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (QZoneSsoHandler.this.mWeakAct.get() != null && !((Activity)QZoneSsoHandler.this.mWeakAct.get()).isFinishing()) {
                        QZoneSsoHandler.this.mTencent.publishToQzone((Activity)QZoneSsoHandler.this.mWeakAct.get(), bundle, QZoneSsoHandler.this.getmShareListener(QZoneSsoHandler.this.mShareListener));
                    }
                }
            });
        }
    }

    private void defaultQZoneShare(final Bundle bundle) {
        if (bundle != null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (QZoneSsoHandler.this.mWeakAct.get() != null && !((Activity)QZoneSsoHandler.this.mWeakAct.get()).isFinishing()) {
                        QZoneSsoHandler.this.mTencent.shareToQzone((Activity)QZoneSsoHandler.this.mWeakAct.get(), bundle, QZoneSsoHandler.this.getmShareListener(QZoneSsoHandler.this.mShareListener));
                    }
                }
            });
        }
    }
}

