/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMusic;

public class QQShareContent
extends SimpleShareContent {
    public int mShareType = 1;
    protected static final String DEFAULT_TARGET_URL = "http://wsq.umeng.com/";

    public QQShareContent(ShareContent shareContent) {
        super(shareContent);
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMusic) {
            this.setMusic((UMusic)shareContent.mMedia);
        }
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMVideo) {
            this.setVideo((UMVideo)shareContent.mMedia);
        }
    }

    public Bundle buildParams() {
        Bundle mParams = new Bundle();
        if (this.getImage() != null && TextUtils.isEmpty((CharSequence)this.getText())) {
            this.mShareType = 5;
            this.buildImageParams(mParams);
        } else if (this.getVideo() != null || this.getMusic() != null) {
            this.mShareType = 2;
            this.buildAudioParams(mParams);
        } else if (this.getImage() != null && !TextUtils.isEmpty((CharSequence)this.getText())) {
            this.buildTextImageParams(mParams);
        }
        mParams.putString("summary", this.getText());
        mParams.putInt("req_type", this.mShareType);
        if (TextUtils.isEmpty((CharSequence)this.getTargeturl())) {
            this.setTargeturl(DEFAULT_TARGET_URL);
        }
        mParams.putString("targetUrl", this.getTargeturl());
        if (!TextUtils.isEmpty((CharSequence)this.getTitle())) {
            mParams.putString("title", this.getTitle());
        } else {
            mParams.putString("title", " ");
        }
        if (Config.QQWITHQZONE == 1) {
            mParams.putInt("cflag", 1);
        } else if (Config.QQWITHQZONE == 2) {
            mParams.putInt("cflag", 2);
        }
        if (!TextUtils.isEmpty((CharSequence)Config.appName)) {
            mParams.putString("appName", Config.appName);
        }
        return mParams;
    }

    private void buildImageParams(Bundle bundle) {
        if (this.getImage() != null) {
            bundle.putString("imageLocalUrl", this.getImage().asFileImage().toString());
        }
    }

    private void buildTextImageParams(Bundle bundle) {
        if (this.getImage() != null) {
            if (this.getImage().isUrlMedia()) {
                bundle.putString("imageUrl", this.getImage().toUrl());
            } else {
                bundle.putString("imageLocalUrl", this.getImage().asFileImage().toString());
            }
        }
    }

    private void buildAudioParams(Bundle bundle) {
        UMusic TEMP = null;
        UMImage thumb = null;
        String thumbpath = null;
        if (this.getMusic() != null) {
            TEMP = this.getMusic();
            thumb = this.getMusic().getThumbImage();
            thumbpath = this.getMusic().getThumb();
        } else if (this.getVideo() != null) {
            TEMP = this.getVideo();
            thumb = this.getVideo().getThumbImage();
            thumbpath = this.getVideo().getThumb();
        }
        if (thumbpath != null) {
            bundle.putString("imageUrl", thumbpath);
        } else if (thumb != null) {
            if (thumb.isUrlMedia()) {
                bundle.putString("imageUrl", thumb.toUrl());
            } else {
                bundle.putString("imageLocalUrl", thumb.asFileImage().toString());
            }
        } else if (this.getImage() != null) {
            if (this.getImage().isUrlMedia()) {
                bundle.putString("imageUrl", this.getImage().toUrl());
            } else {
                bundle.putString("imageLocalUrl", this.getImage().asFileImage().toString());
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.getTargeturl())) {
            this.setTargeturl(TEMP.toUrl());
        }
        bundle.putString("audio_url", TEMP.toUrl());
    }
}

