/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.utils.Log;
import java.util.HashMap;
import java.util.Map;

public class WeixinPreferences {
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_ACCESS_TOKEN_TTL = "expires_in";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";
    private static final String KEY_REFRESH_TOKEN_TTL = "rt_expires_in";
    private static final String KEY_OPENID = "openid";
    private static final String KEY_EXPIRES_IN = "expires_in";
    private SharedPreferences sharedPreferences = null;
    private String mUID;
    private String mAccessToken;
    private long mAccessTokenTTL;
    private String mRefreshToken;
    private long mRefreshTokenTTL;
    private long mexpirein;

    public WeixinPreferences(Context context, String name) {
        this.sharedPreferences = context.getSharedPreferences(name, 0);
        this.mUID = this.sharedPreferences.getString(KEY_OPENID, null);
        this.mAccessToken = this.sharedPreferences.getString(KEY_ACCESS_TOKEN, null);
        this.mAccessTokenTTL = this.sharedPreferences.getLong("expires_in", 0L);
        this.mRefreshToken = this.sharedPreferences.getString(KEY_REFRESH_TOKEN, null);
        this.mRefreshTokenTTL = this.sharedPreferences.getLong(KEY_REFRESH_TOKEN_TTL, 0L);
        this.mexpirein = this.sharedPreferences.getLong("expires_in", 0L);
    }

    public WeixinPreferences setAuthData(Map<String, String> map) {
        String refreshTTL;
        String accessTTL;
        this.mUID = map.get(KEY_OPENID);
        this.mAccessToken = map.get(KEY_ACCESS_TOKEN);
        this.mRefreshToken = map.get(KEY_REFRESH_TOKEN);
        String time = map.get("expires_in");
        if (!TextUtils.isEmpty((CharSequence)time)) {
            this.mexpirein = Long.valueOf(time) * 1000L + System.currentTimeMillis();
        }
        if (!TextUtils.isEmpty((CharSequence)(accessTTL = map.get("expires_in")))) {
            this.mAccessTokenTTL = Long.valueOf(accessTTL) * 1000L + System.currentTimeMillis();
        }
        if (!TextUtils.isEmpty((CharSequence)(refreshTTL = map.get(KEY_REFRESH_TOKEN_TTL)))) {
            this.mRefreshTokenTTL = Long.valueOf(refreshTTL) * 1000L + System.currentTimeMillis();
        }
        return this;
    }

    public WeixinPreferences setBundle(Bundle bundle) {
        String refreshTTL;
        String accessTTL;
        this.mUID = bundle.getString(KEY_OPENID);
        this.mAccessToken = bundle.getString(KEY_ACCESS_TOKEN);
        this.mRefreshToken = bundle.getString(KEY_REFRESH_TOKEN);
        String time = bundle.getString("expires_in");
        if (!TextUtils.isEmpty((CharSequence)time)) {
            this.mexpirein = Long.valueOf(time) * 1000L + System.currentTimeMillis();
        }
        if (!TextUtils.isEmpty((CharSequence)(accessTTL = bundle.getString("expires_in")))) {
            this.mAccessTokenTTL = Long.valueOf(accessTTL) * 1000L + System.currentTimeMillis();
        }
        if (!TextUtils.isEmpty((CharSequence)(refreshTTL = bundle.getString(KEY_REFRESH_TOKEN_TTL)))) {
            this.mRefreshTokenTTL = Long.valueOf(refreshTTL) * 1000L + System.currentTimeMillis();
        }
        this.commit();
        return this;
    }

    public String getUID() {
        return this.mUID;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public Map<String, String> getmap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_ACCESS_TOKEN, this.mAccessToken);
        map.put(KEY_OPENID, this.mUID);
        map.put(KEY_REFRESH_TOKEN, this.mRefreshToken);
        return map;
    }

    public boolean isAccessTokenAvailable() {
        boolean isNull = TextUtils.isEmpty((CharSequence)this.mAccessToken);
        boolean isExpired = this.mexpirein - System.currentTimeMillis() <= 0L;
        return !isNull && !isExpired;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public boolean isAuthValid() {
        boolean isNull = TextUtils.isEmpty((CharSequence)this.mRefreshToken);
        boolean isExpired = this.mRefreshTokenTTL - System.currentTimeMillis() <= 0L;
        Log.e((String)("timetree isNull=" + isNull + "   mRefreshTokenTTL=" + this.mRefreshTokenTTL));
        return !isNull && !isExpired;
    }

    public boolean isAuth() {
        boolean isNull = TextUtils.isEmpty((CharSequence)this.getAccessToken());
        return !isNull;
    }

    public void delete() {
        this.sharedPreferences.edit().clear().commit();
    }

    public void commit() {
        this.sharedPreferences.edit().putString(KEY_OPENID, this.mUID).putString(KEY_ACCESS_TOKEN, this.mAccessToken).putLong("expires_in", this.mAccessTokenTTL).putString(KEY_REFRESH_TOKEN, this.mRefreshToken).putLong(KEY_REFRESH_TOKEN_TTL, this.mRefreshTokenTTL).putLong("expires_in", this.mexpirein).commit();
    }
}

