/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.graphics.Bitmap;
import android.text.TextUtils;
import com.tencent.mm.sdk.modelmsg.WXEmojiObject;
import com.tencent.mm.sdk.modelmsg.WXFileObject;
import com.tencent.mm.sdk.modelmsg.WXImageObject;
import com.tencent.mm.sdk.modelmsg.WXMediaMessage;
import com.tencent.mm.sdk.modelmsg.WXMusicObject;
import com.tencent.mm.sdk.modelmsg.WXTextObject;
import com.tencent.mm.sdk.modelmsg.WXVideoObject;
import com.tencent.mm.sdk.modelmsg.WXWebpageObject;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.UMEmoji;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.BitmapUtils;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.io.File;

public class WeiXinShareContent {
    private final String DEFAULT_TITLE = "\u5206\u4eab\u5230\u5fae\u4fe1";
    private WXMediaMessage mWxMediaMessage = null;
    private final int THUMB_SIZE = 150;
    private final int THUMB_LIMIT = 24576;
    private final int IMAGE_LIMIT = 65536;
    private final int TITLE_LIMIT = 512;
    private final int DESCRIPTION_LIMIT = 1024;
    public String mShareType;
    private ShareContent mShareContent;
    private String mTitle;
    private String mTargetUrl;
    private final int SHOW_COMPRESS_TOAST = 1;
    private final int SHOW_TITLE_TOAST = 2;
    private String mText;
    private UMediaObject uMediaObject;
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_TEXT_IMAGE = "text_image";
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_MUSIC = "music";
    public static final String TYPE_EMOJI = "emoji";

    public WeiXinShareContent(ShareContent shareContent) {
        this.mShareContent = shareContent;
        this.mTitle = shareContent.mTitle;
        this.mText = shareContent.mText;
        this.uMediaObject = shareContent.mMedia;
        this.mTargetUrl = shareContent.mTargetUrl;
    }

    public void parseMediaType() {
        if (!TextUtils.isEmpty((CharSequence)this.mText) && this.uMediaObject == null) {
            this.mShareType = TYPE_TEXT;
        } else if (this.uMediaObject != null && this.uMediaObject instanceof UMEmoji) {
            this.mShareType = TYPE_EMOJI;
        } else if (TextUtils.isEmpty((CharSequence)this.mText) && this.uMediaObject != null && this.uMediaObject instanceof UMImage) {
            this.mShareType = TYPE_IMAGE;
        } else if (this.uMediaObject != null && this.uMediaObject instanceof UMusic) {
            this.mShareType = TYPE_MUSIC;
        } else if (this.uMediaObject != null && this.uMediaObject instanceof UMVideo) {
            this.mShareType = TYPE_VIDEO;
        } else if (!TextUtils.isEmpty((CharSequence)this.mText) && this.uMediaObject != null && this.uMediaObject instanceof UMImage) {
            this.mShareType = TYPE_TEXT_IMAGE;
        }
    }

    public WXMediaMessage getWxMediaMessage() {
        WXMediaMessage wxMessage = null;
        if (this.mShareContent.file != null) {
            wxMessage = this.buildFileParams();
        } else if (this.mShareContent.mMedia == null) {
            if (!TextUtils.isEmpty((CharSequence)this.mShareContent.mText)) {
                wxMessage = TextUtils.isEmpty((CharSequence)this.mShareContent.mTargetUrl) ? this.buildTextParams() : this.buildUrlParams();
            }
        } else if (this.mShareContent.mMedia instanceof UMEmoji) {
            wxMessage = this.buildEmojiParams();
        } else if (TextUtils.isEmpty((CharSequence)this.mShareContent.mText) && this.mShareContent.mMedia instanceof UMImage) {
            wxMessage = this.buildImageParams();
        } else if (this.mShareContent.mMedia instanceof UMusic) {
            wxMessage = this.buildMusicParams();
        } else if (this.mShareContent.mMedia instanceof UMVideo) {
            wxMessage = this.buildVideoParams();
        } else if (!TextUtils.isEmpty((CharSequence)this.mShareContent.mText) && this.mShareContent.mMedia instanceof UMImage) {
            wxMessage = TextUtils.isEmpty((CharSequence)this.mShareContent.mTargetUrl) ? this.buildImageParams() : this.buildUrlParams();
        }
        if (wxMessage != null) {
            byte[] datas;
            byte[] thumbData = wxMessage.thumbData;
            if (thumbData != null && thumbData.length > 24576) {
                wxMessage.thumbData = BitmapUtils.compressBitmap((byte[])thumbData, (int)24576);
                Log.d((String)("\u538b\u7f29\u4e4b\u540e\u7f29\u7565\u56fe\u5927\u5c0f : " + wxMessage.thumbData.length / 1024 + " KB."));
            }
            if (!TextUtils.isEmpty((CharSequence)wxMessage.title) && wxMessage.title.getBytes().length >= 512) {
                datas = wxMessage.title.getBytes();
                wxMessage.title = new String(datas, 0, 512);
            } else {
                this.mTitle = "\u5206\u4eab\u5230\u5fae\u4fe1";
            }
            if (!TextUtils.isEmpty((CharSequence)wxMessage.description) && wxMessage.description.getBytes().length >= 1024) {
                datas = wxMessage.description.getBytes();
                wxMessage.description = new String(datas, 0, 1024);
            }
        }
        return wxMessage;
    }

    private WXMediaMessage buildEmojiParams() {
        UMEmoji emoji = (UMEmoji)this.mShareContent.mMedia;
        UMImage image = emoji.mSrcImage;
        String path = image.asFileImage().toString();
        WXEmojiObject wxEmojiObject = new WXEmojiObject();
        if (emoji.mSrcImage.isUrlMedia() && !new File(path = BitmapUtils.getFileName((String)image.toUrl())).exists()) {
            BitmapUtils.loadImage((String)image.toUrl(), (int)150, (int)150);
        }
        wxEmojiObject.emojiPath = path;
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = wxEmojiObject;
        if (emoji.getThumbImage() != null) {
            msg.thumbData = emoji.mThumb.toByte();
        } else if (!TextUtils.isEmpty((CharSequence)emoji.getThumb())) {
            Bitmap bitmap = BitmapUtils.loadImage((String)emoji.getThumb(), (int)150, (int)150);
            msg.thumbData = BitmapUtils.bitmap2Bytes((Bitmap)bitmap);
            bitmap.recycle();
        } else {
            msg.thumbData = emoji.mSrcImage.toByte();
        }
        msg.title = this.mTitle;
        msg.description = this.mShareContent.mText;
        return msg;
    }

    private WXMediaMessage buildMusicParams() {
        UMusic umusic = (UMusic)this.mShareContent.mMedia;
        WXMusicObject music = new WXMusicObject();
        music.musicUrl = TextUtils.isEmpty((CharSequence)umusic.getTargetUrl()) ? (TextUtils.isEmpty((CharSequence)this.mShareContent.mTargetUrl) ? "http://wsq.umeng.com" : this.mShareContent.mTargetUrl) : umusic.getTargetUrl();
        music.musicDataUrl = umusic.toUrl();
        if (!TextUtils.isEmpty((CharSequence)umusic.getLowBandDataUrl())) {
            music.musicLowBandDataUrl = umusic.getLowBandDataUrl();
        }
        if (!TextUtils.isEmpty((CharSequence)umusic.getLowBandUrl())) {
            music.musicLowBandUrl = umusic.getLowBandUrl();
        }
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = music;
        msg.title = TextUtils.isEmpty((CharSequence)umusic.getTitle()) ? (TextUtils.isEmpty((CharSequence)this.mShareContent.mTitle) ? "\u5206\u4eab\u97f3\u9891" : this.mShareContent.mTitle) : umusic.getTitle();
        msg.description = this.mShareContent.mText;
        msg.mediaObject = music;
        if (!(umusic.getThumb() == null || "".equals(umusic.getThumb()) && umusic.getThumb() == null)) {
            byte[] data = null;
            if (umusic.getThumbImage() != null) {
                data = umusic.getThumbImage().asBinImage();
            } else if (!TextUtils.isEmpty((CharSequence)umusic.getThumb())) {
                data = new UMImage(ContextUtil.getContext(), umusic.getThumb()).asBinImage();
            }
            if (data != null) {
                Log.d((String)"share with thumb");
                msg.thumbData = data;
            }
        }
        return msg;
    }

    private WXMediaMessage buildFileParams() {
        WXFileObject textObj = new WXFileObject();
        textObj.fileData = SocializeUtils.File2byte((File)this.mShareContent.file);
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = textObj;
        msg.description = this.mShareContent.mText;
        msg.title = this.mTitle;
        return msg;
    }

    private WXMediaMessage buildTextParams() {
        WXTextObject textObj = new WXTextObject();
        textObj.text = this.mShareContent.mText;
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = textObj;
        msg.description = this.mShareContent.mText;
        msg.title = this.mTitle;
        return msg;
    }

    private WXMediaMessage buildImageParams() {
        UMImage img = (UMImage)this.mShareContent.mMedia;
        WXImageObject imgObj = new WXImageObject();
        WXMediaMessage msg = new WXMediaMessage();
        imgObj.imageData = img.asBinImage();
        msg.thumbData = img.asBinImage();
        byte[] thumbData = msg.thumbData;
        if (thumbData != null && thumbData.length > 65536) {
            msg.thumbData = BitmapUtils.compressBitmap((byte[])thumbData, (int)65536);
        }
        msg.mediaObject = imgObj;
        return msg;
    }

    private WXMediaMessage buildVideoParams() {
        UMVideo uvideo = (UMVideo)this.mShareContent.mMedia;
        WXVideoObject video = new WXVideoObject();
        video.videoUrl = uvideo.toUrl();
        if (!TextUtils.isEmpty((CharSequence)uvideo.getLowBandUrl())) {
            video.videoLowBandUrl = uvideo.getLowBandUrl();
        }
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = video;
        msg.title = TextUtils.isEmpty((CharSequence)this.mShareContent.mTitle) ? "\u5206\u4eab\u89c6\u9891" : this.mShareContent.mTitle;
        msg.description = this.mShareContent.mText;
        byte[] thumbData = null;
        if (!TextUtils.isEmpty((CharSequence)uvideo.getThumb())) {
            thumbData = new UMImage(ContextUtil.getContext(), uvideo.getThumb()).asBinImage();
        } else if (uvideo.getThumbImage() != null) {
            thumbData = uvideo.getThumbImage().asBinImage();
        }
        if (thumbData != null && thumbData.length > 0) {
            msg.thumbData = thumbData;
        }
        return msg;
    }

    private WXMediaMessage buildTextImageParams() {
        UMImage img = (UMImage)this.mShareContent.mMedia;
        if (TextUtils.isEmpty((CharSequence)this.mTargetUrl)) {
            this.mTargetUrl = "http://www.umeng.com";
        }
        WXWebpageObject webpage = new WXWebpageObject();
        webpage.webpageUrl = this.mTargetUrl;
        WXMediaMessage msg = new WXMediaMessage();
        msg.title = this.mTitle;
        msg.description = this.mShareContent.mText;
        msg.mediaObject = webpage;
        msg.thumbData = img.asBinImage();
        return msg;
    }

    private WXMediaMessage buildUrlParams() {
        UMImage img = (UMImage)this.mShareContent.mMedia;
        if (TextUtils.isEmpty((CharSequence)this.mTargetUrl)) {
            this.mTargetUrl = "http://www.umeng.com";
        }
        WXWebpageObject webpage = new WXWebpageObject();
        webpage.webpageUrl = this.mTargetUrl;
        WXMediaMessage msg = new WXMediaMessage();
        msg.title = this.mTitle;
        msg.description = this.mShareContent.mText;
        msg.mediaObject = webpage;
        if (img != null) {
            msg.thumbData = img.asBinImage();
        }
        return msg;
    }
}

