/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.gesture;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewParent;
import lecho.lib.hellocharts.computator.ChartComputator;
import lecho.lib.hellocharts.gesture.ChartScroller;
import lecho.lib.hellocharts.gesture.ChartZoomer;
import lecho.lib.hellocharts.gesture.ContainerScrollType;
import lecho.lib.hellocharts.gesture.ZoomType;
import lecho.lib.hellocharts.model.SelectedValue;
import lecho.lib.hellocharts.renderer.ChartRenderer;
import lecho.lib.hellocharts.view.Chart;

public class ChartTouchHandler {
    protected GestureDetector gestureDetector;
    protected ScaleGestureDetector scaleGestureDetector;
    protected ChartScroller chartScroller;
    protected ChartZoomer chartZoomer;
    protected Chart chart;
    protected ChartComputator computator;
    protected ChartRenderer renderer;
    protected boolean isZoomEnabled = true;
    protected boolean isScrollEnabled = true;
    protected boolean isValueTouchEnabled = true;
    protected boolean isValueSelectionEnabled = false;
    protected SelectedValue selectionModeOldValue = new SelectedValue();
    protected SelectedValue selectedValue = new SelectedValue();
    protected SelectedValue oldSelectedValue = new SelectedValue();
    protected ViewParent viewParent;
    protected ContainerScrollType containerScrollType;

    public ChartTouchHandler(Context context, Chart chart) {
        this.chart = chart;
        this.computator = chart.getChartComputator();
        this.renderer = chart.getChartRenderer();
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ChartGestureListener());
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ChartScaleGestureListener());
        this.chartScroller = new ChartScroller(context);
        this.chartZoomer = new ChartZoomer(context, ZoomType.HORIZONTAL_AND_VERTICAL);
    }

    public void resetTouchHandler() {
        this.computator = this.chart.getChartComputator();
        this.renderer = this.chart.getChartRenderer();
    }

    public boolean computeScroll() {
        boolean needInvalidate = false;
        if (this.isScrollEnabled && this.chartScroller.computeScrollOffset(this.computator)) {
            needInvalidate = true;
        }
        if (this.isZoomEnabled && this.chartZoomer.computeZoom(this.computator)) {
            needInvalidate = true;
        }
        return needInvalidate;
    }

    public boolean handleTouchEvent(MotionEvent event) {
        boolean needInvalidate = false;
        needInvalidate = this.gestureDetector.onTouchEvent(event);
        boolean bl = needInvalidate = this.scaleGestureDetector.onTouchEvent(event) || needInvalidate;
        if (this.isZoomEnabled && this.scaleGestureDetector.isInProgress()) {
            this.disallowParentInterceptTouchEvent();
        }
        if (this.isValueTouchEnabled) {
            needInvalidate = this.computeTouch(event) || needInvalidate;
        }
        return needInvalidate;
    }

    public boolean handleTouchEvent(MotionEvent event, ViewParent viewParent, ContainerScrollType containerScrollType) {
        this.viewParent = viewParent;
        this.containerScrollType = containerScrollType;
        return this.handleTouchEvent(event);
    }

    private void disallowParentInterceptTouchEvent() {
        if (null != this.viewParent) {
            this.viewParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    private void allowParentInterceptTouchEvent(ChartScroller.ScrollResult scrollResult) {
        if (null != this.viewParent) {
            if (ContainerScrollType.HORIZONTAL == this.containerScrollType && !scrollResult.canScrollX && !this.scaleGestureDetector.isInProgress()) {
                this.viewParent.requestDisallowInterceptTouchEvent(false);
            } else if (ContainerScrollType.VERTICAL == this.containerScrollType && !scrollResult.canScrollY && !this.scaleGestureDetector.isInProgress()) {
                this.viewParent.requestDisallowInterceptTouchEvent(false);
            }
        }
    }

    private boolean computeTouch(MotionEvent event) {
        boolean needInvalidate = false;
        switch (event.getAction()) {
            case 0: {
                boolean wasTouched = this.renderer.isTouched();
                boolean isTouched = this.checkTouch(event.getX(), event.getY());
                if (wasTouched == isTouched) break;
                needInvalidate = true;
                if (!this.isValueSelectionEnabled) break;
                this.selectionModeOldValue.clear();
                if (!wasTouched || this.renderer.isTouched()) break;
                this.chart.callTouchListener();
                break;
            }
            case 1: {
                if (!this.renderer.isTouched()) break;
                if (this.checkTouch(event.getX(), event.getY())) {
                    if (this.isValueSelectionEnabled) {
                        if (!this.selectionModeOldValue.equals(this.selectedValue)) {
                            this.selectionModeOldValue.set(this.selectedValue);
                            this.chart.callTouchListener();
                        }
                    } else {
                        this.chart.callTouchListener();
                        this.renderer.clearTouch();
                    }
                } else {
                    this.renderer.clearTouch();
                }
                needInvalidate = true;
                break;
            }
            case 2: {
                if (!this.renderer.isTouched() || this.checkTouch(event.getX(), event.getY())) break;
                this.renderer.clearTouch();
                needInvalidate = true;
                break;
            }
            case 3: {
                if (!this.renderer.isTouched()) break;
                this.renderer.clearTouch();
                needInvalidate = true;
            }
        }
        return needInvalidate;
    }

    private boolean checkTouch(float touchX, float touchY) {
        this.oldSelectedValue.set(this.selectedValue);
        this.selectedValue.clear();
        if (this.renderer.checkTouch(touchX, touchY)) {
            this.selectedValue.set(this.renderer.getSelectedValue());
        }
        if (this.oldSelectedValue.isSet() && this.selectedValue.isSet() && !this.oldSelectedValue.equals(this.selectedValue)) {
            return false;
        }
        return this.renderer.isTouched();
    }

    public boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public void setZoomEnabled(boolean isZoomEnabled) {
        this.isZoomEnabled = isZoomEnabled;
    }

    public boolean isScrollEnabled() {
        return this.isScrollEnabled;
    }

    public void setScrollEnabled(boolean isScrollEnabled) {
        this.isScrollEnabled = isScrollEnabled;
    }

    public ZoomType getZoomType() {
        return this.chartZoomer.getZoomType();
    }

    public void setZoomType(ZoomType zoomType) {
        this.chartZoomer.setZoomType(zoomType);
    }

    public boolean isValueTouchEnabled() {
        return this.isValueTouchEnabled;
    }

    public void setValueTouchEnabled(boolean isValueTouchEnabled) {
        this.isValueTouchEnabled = isValueTouchEnabled;
    }

    public boolean isValueSelectionEnabled() {
        return this.isValueSelectionEnabled;
    }

    public void setValueSelectionEnabled(boolean isValueSelectionEnabled) {
        this.isValueSelectionEnabled = isValueSelectionEnabled;
    }

    protected class ChartGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        protected ChartScroller.ScrollResult scrollResult = new ChartScroller.ScrollResult();

        protected ChartGestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            if (ChartTouchHandler.this.isScrollEnabled) {
                ChartTouchHandler.this.disallowParentInterceptTouchEvent();
                return ChartTouchHandler.this.chartScroller.startScroll(ChartTouchHandler.this.computator);
            }
            return false;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (ChartTouchHandler.this.isZoomEnabled) {
                return ChartTouchHandler.this.chartZoomer.startZoom(e, ChartTouchHandler.this.computator);
            }
            return false;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (ChartTouchHandler.this.isScrollEnabled) {
                boolean canScroll = ChartTouchHandler.this.chartScroller.scroll(ChartTouchHandler.this.computator, distanceX, distanceY, this.scrollResult);
                ChartTouchHandler.this.allowParentInterceptTouchEvent(this.scrollResult);
                return canScroll;
            }
            return false;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (ChartTouchHandler.this.isScrollEnabled) {
                return ChartTouchHandler.this.chartScroller.fling((int)(-velocityX), (int)(-velocityY), ChartTouchHandler.this.computator);
            }
            return false;
        }
    }

    protected class ChartScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        protected ChartScaleGestureListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (ChartTouchHandler.this.isZoomEnabled) {
                float scale = 2.0f - detector.getScaleFactor();
                if (Float.isInfinite(scale)) {
                    scale = 1.0f;
                }
                return ChartTouchHandler.this.chartZoomer.scale(ChartTouchHandler.this.computator, detector.getFocusX(), detector.getFocusY(), scale);
            }
            return false;
        }
    }
}

