/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.EncodingMismatchException;
import com.hp.hpl.sparta.ParseCharStream;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.ParseHandler;
import com.hp.hpl.sparta.ParseLog;
import com.hp.hpl.sparta.ParseSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

class ParseByteStream
implements ParseSource {
    private ParseCharStream parseSource_;

    public ParseByteStream(String string, InputStream inputStream, ParseLog parseLog, String string2, ParseHandler parseHandler) throws ParseException, IOException {
        if (parseLog == null) {
            parseLog = ParseSource.DEFAULT_LOG;
        }
        if (!inputStream.markSupported()) {
            throw new Error("Precondition violation: the InputStream passed to ParseByteStream must support mark");
        }
        inputStream.mark(ParseSource.MAXLOOKAHEAD);
        byte[] byArray = new byte[4];
        int n = inputStream.read(byArray);
        if (string2 == null) {
            string2 = ParseByteStream.guessEncoding(string, byArray, n, parseLog);
        }
        try {
            inputStream.reset();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, ParseByteStream.fixEncoding(string2));
            try {
                this.parseSource_ = new ParseCharStream(string, inputStreamReader, parseLog, string2, parseHandler);
            }
            catch (IOException iOException) {
                String string3 = "euc-jp";
                parseLog.note("Problem reading with assumed encoding of " + string2 + " so restarting with " + string3, string, 1);
                inputStream.reset();
                try {
                    inputStreamReader = new InputStreamReader(inputStream, ParseByteStream.fixEncoding(string3));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ParseException(parseLog, string, 1, 0, string3, "\"" + string3 + "\" is not a supported encoding");
                }
                this.parseSource_ = new ParseCharStream(string, inputStreamReader, parseLog, null, parseHandler);
            }
        }
        catch (EncodingMismatchException encodingMismatchException) {
            InputStreamReader inputStreamReader;
            String string4 = encodingMismatchException.getDeclaredEncoding();
            parseLog.note("Encoding declaration of " + string4 + " is different that assumed " + string2 + " so restarting the parsing with the new encoding", string, 1);
            inputStream.reset();
            try {
                inputStreamReader = new InputStreamReader(inputStream, ParseByteStream.fixEncoding(string4));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ParseException(parseLog, string, 1, 0, string4, "\"" + string4 + "\" is not a supported encoding");
            }
            this.parseSource_ = new ParseCharStream(string, inputStreamReader, parseLog, null, parseHandler);
        }
    }

    public String toString() {
        return this.parseSource_.toString();
    }

    public String getSystemId() {
        return this.parseSource_.getSystemId();
    }

    public int getLineNumber() {
        return this.parseSource_.getLineNumber();
    }

    private static String guessEncoding(String string, byte[] byArray, int n, ParseLog parseLog) throws IOException {
        String string2;
        if (n != 4) {
            String string3 = n <= 0 ? "no characters in input" : "less than 4 characters in input: \"" + new String(byArray, 0, n) + "\"";
            parseLog.error(string3, string, 1);
            string2 = "UTF-8";
        } else {
            string2 = ParseByteStream.equals(byArray, 65279) || ParseByteStream.equals(byArray, -131072) || ParseByteStream.equals(byArray, 65534) || ParseByteStream.equals(byArray, -16842752) || ParseByteStream.equals(byArray, 60) || ParseByteStream.equals(byArray, 0x3C000000) || ParseByteStream.equals(byArray, 15360) || ParseByteStream.equals(byArray, 0x3C0000) ? "UCS-4" : (ParseByteStream.equals(byArray, 3932223) ? "UTF-16BE" : (ParseByteStream.equals(byArray, 1006649088) ? "UTF-16LE" : (ParseByteStream.equals(byArray, 1010792557) ? "UTF-8" : (ParseByteStream.equals(byArray, 1282385812) ? "EBCDIC" : (ParseByteStream.equals(byArray, (short)-2) || ParseByteStream.equals(byArray, (short)-257) ? "UTF-16" : "UTF-8")))));
        }
        if (!string2.equals("UTF-8")) {
            parseLog.note("From start " + ParseByteStream.hex(byArray[0]) + " " + ParseByteStream.hex(byArray[1]) + " " + ParseByteStream.hex(byArray[2]) + " " + ParseByteStream.hex(byArray[3]) + " deduced encoding = " + string2, string, 1);
        }
        return string2;
    }

    private static String hex(byte by) {
        String string = Integer.toHexString(by);
        switch (string.length()) {
            case 1: {
                return "0" + string;
            }
            case 2: {
                return string;
            }
        }
        return string.substring(string.length() - 2);
    }

    private static boolean equals(byte[] byArray, int n) {
        return byArray[0] == (byte)(n >>> 24) && byArray[1] == (byte)(n >>> 16 & 0xFF) && byArray[2] == (byte)(n >>> 8 & 0xFF) && byArray[3] == (byte)(n & 0xFF);
    }

    private static boolean equals(byte[] byArray, short s) {
        return byArray[0] == (byte)(s >>> 8) && byArray[1] == (byte)(s & 0xFF);
    }

    private static String fixEncoding(String string) {
        return string.toLowerCase().equals("utf8") ? "UTF-8" : string;
    }
}

