/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeMemoryCache<K, V>
implements MemoryCacheAware<K, V> {
    private final MemoryCacheAware<K, V> cache;
    private final long maxAge;
    private final Map<K, Long> loadingDates = Collections.synchronizedMap(new HashMap());

    public LimitedAgeMemoryCache(MemoryCacheAware<K, V> cache, long maxAge) {
        this.cache = cache;
        this.maxAge = maxAge * 1000L;
    }

    @Override
    public boolean put(K key, V value) {
        boolean putSuccesfully = this.cache.put(key, value);
        if (putSuccesfully) {
            this.loadingDates.put(key, System.currentTimeMillis());
        }
        return putSuccesfully;
    }

    @Override
    public V get(K key) {
        Long loadingDate = this.loadingDates.get(key);
        if (loadingDate != null && System.currentTimeMillis() - loadingDate > this.maxAge) {
            this.cache.remove(key);
            this.loadingDates.remove(key);
        }
        return this.cache.get(key);
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
        this.loadingDates.remove(key);
    }

    @Override
    public Collection<K> keys() {
        return this.cache.keys();
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.loadingDates.clear();
    }
}

