/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VolleyLog {
    public static String TAG = "Volley";
    public static boolean DEBUG = Log.isLoggable((String)TAG, (int)2);

    public static void setTag(String tag) {
        VolleyLog.d("Changing log tag to %s", tag);
        TAG = tag;
        DEBUG = Log.isLoggable((String)TAG, (int)2);
    }

    public static void v(String format, Object ... args) {
        if (DEBUG) {
            Log.v((String)TAG, (String)VolleyLog.buildMessage(format, args));
        }
    }

    public static void d(String format, Object ... args) {
        Log.d((String)TAG, (String)VolleyLog.buildMessage(format, args));
    }

    public static void e(String format, Object ... args) {
        Log.e((String)TAG, (String)VolleyLog.buildMessage(format, args));
    }

    public static void e(Throwable tr, String format, Object ... args) {
        Log.e((String)TAG, (String)VolleyLog.buildMessage(format, args), (Throwable)tr);
    }

    public static void wtf(String format, Object ... args) {
        Log.wtf((String)TAG, (String)VolleyLog.buildMessage(format, args));
    }

    public static void wtf(Throwable tr, String format, Object ... args) {
        Log.wtf((String)TAG, (String)VolleyLog.buildMessage(format, args), (Throwable)tr);
    }

    private static String buildMessage(String format, Object ... args) {
        String msg = args == null ? format : String.format(Locale.US, format, args);
        StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
        String caller = "<unknown>";
        int i = 2;
        while (i < trace.length) {
            Class<?> clazz = trace[i].getClass();
            if (!clazz.equals(VolleyLog.class)) {
                String callingClass = trace[i].getClassName();
                callingClass = callingClass.substring(callingClass.lastIndexOf(46) + 1);
                callingClass = callingClass.substring(callingClass.lastIndexOf(36) + 1);
                caller = String.valueOf(callingClass) + "." + trace[i].getMethodName();
                break;
            }
            ++i;
        }
        return String.format(Locale.US, "[%d] %s: %s", Thread.currentThread().getId(), caller, msg);
    }

    static class MarkerLog {
        public static final boolean ENABLED = DEBUG;
        private static final long MIN_DURATION_FOR_LOGGING_MS = 0L;
        private final List<Marker> mMarkers = new ArrayList<Marker>();
        private boolean mFinished = false;

        MarkerLog() {
        }

        public synchronized void add(String name, long threadId) {
            if (this.mFinished) {
                throw new IllegalStateException("Marker added to finished log");
            }
            this.mMarkers.add(new Marker(name, threadId, SystemClock.elapsedRealtime()));
        }

        public synchronized void finish(String header) {
            this.mFinished = true;
            long duration = this.getTotalDuration();
            if (duration <= 0L) {
                return;
            }
            long prevTime = this.mMarkers.get((int)0).time;
            VolleyLog.d("(%-4d ms) %s", duration, header);
            for (Marker marker : this.mMarkers) {
                long thisTime = marker.time;
                VolleyLog.d("(+%-4d) [%2d] %s", thisTime - prevTime, marker.thread, marker.name);
                prevTime = thisTime;
            }
        }

        protected void finalize() throws Throwable {
            if (!this.mFinished) {
                this.finish("Request on the loose");
                VolleyLog.e("Marker log finalized without finish() - uncaught exit point for request", new Object[0]);
            }
        }

        private long getTotalDuration() {
            if (this.mMarkers.size() == 0) {
                return 0L;
            }
            long first = this.mMarkers.get((int)0).time;
            long last = this.mMarkers.get((int)(this.mMarkers.size() - 1)).time;
            return last - first;
        }

        private static class Marker {
            public final String name;
            public final long thread;
            public final long time;

            public Marker(String name, long thread, long time) {
                this.name = name;
                this.thread = thread;
                this.time = time;
            }
        }
    }
}

