/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.converter;

import com.lidroid.xutils.db.converter.BooleanColumnConverter;
import com.lidroid.xutils.db.converter.ByteArrayColumnConverter;
import com.lidroid.xutils.db.converter.ByteColumnConverter;
import com.lidroid.xutils.db.converter.CharColumnConverter;
import com.lidroid.xutils.db.converter.ColumnConverter;
import com.lidroid.xutils.db.converter.DateColumnConverter;
import com.lidroid.xutils.db.converter.DoubleColumnConverter;
import com.lidroid.xutils.db.converter.FloatColumnConverter;
import com.lidroid.xutils.db.converter.IntegerColumnConverter;
import com.lidroid.xutils.db.converter.LongColumnConverter;
import com.lidroid.xutils.db.converter.ShortColumnConverter;
import com.lidroid.xutils.db.converter.SqlDateColumnConverter;
import com.lidroid.xutils.db.converter.StringColumnConverter;
import com.lidroid.xutils.db.sqlite.ColumnDbType;
import java.sql.Date;
import java.util.concurrent.ConcurrentHashMap;

public class ColumnConverterFactory {
    private static final ConcurrentHashMap<String, ColumnConverter> columnType_columnConverter_map = new ConcurrentHashMap();

    static {
        BooleanColumnConverter booleanColumnConverter = new BooleanColumnConverter();
        columnType_columnConverter_map.put(Boolean.TYPE.getCanonicalName(), booleanColumnConverter);
        columnType_columnConverter_map.put(Boolean.class.getCanonicalName(), booleanColumnConverter);
        ByteArrayColumnConverter byteArrayColumnConverter = new ByteArrayColumnConverter();
        columnType_columnConverter_map.put(byte[].class.getCanonicalName(), byteArrayColumnConverter);
        ByteColumnConverter byteColumnConverter = new ByteColumnConverter();
        columnType_columnConverter_map.put(Byte.TYPE.getCanonicalName(), byteColumnConverter);
        columnType_columnConverter_map.put(Byte.class.getCanonicalName(), byteColumnConverter);
        CharColumnConverter charColumnConverter = new CharColumnConverter();
        columnType_columnConverter_map.put(Character.TYPE.getCanonicalName(), charColumnConverter);
        columnType_columnConverter_map.put(Character.class.getCanonicalName(), charColumnConverter);
        DateColumnConverter dateColumnConverter = new DateColumnConverter();
        columnType_columnConverter_map.put(java.util.Date.class.getCanonicalName(), dateColumnConverter);
        DoubleColumnConverter doubleColumnConverter = new DoubleColumnConverter();
        columnType_columnConverter_map.put(Double.TYPE.getCanonicalName(), doubleColumnConverter);
        columnType_columnConverter_map.put(Double.class.getCanonicalName(), doubleColumnConverter);
        FloatColumnConverter floatColumnConverter = new FloatColumnConverter();
        columnType_columnConverter_map.put(Float.TYPE.getCanonicalName(), floatColumnConverter);
        columnType_columnConverter_map.put(Float.class.getCanonicalName(), floatColumnConverter);
        IntegerColumnConverter integerColumnConverter = new IntegerColumnConverter();
        columnType_columnConverter_map.put(Integer.TYPE.getCanonicalName(), integerColumnConverter);
        columnType_columnConverter_map.put(Integer.class.getCanonicalName(), integerColumnConverter);
        LongColumnConverter longColumnConverter = new LongColumnConverter();
        columnType_columnConverter_map.put(Long.TYPE.getCanonicalName(), longColumnConverter);
        columnType_columnConverter_map.put(Long.class.getCanonicalName(), longColumnConverter);
        ShortColumnConverter shortColumnConverter = new ShortColumnConverter();
        columnType_columnConverter_map.put(Short.TYPE.getCanonicalName(), shortColumnConverter);
        columnType_columnConverter_map.put(Short.class.getCanonicalName(), shortColumnConverter);
        SqlDateColumnConverter sqlDateColumnConverter = new SqlDateColumnConverter();
        columnType_columnConverter_map.put(Date.class.getCanonicalName(), sqlDateColumnConverter);
        StringColumnConverter stringColumnConverter = new StringColumnConverter();
        columnType_columnConverter_map.put(String.class.getCanonicalName(), stringColumnConverter);
    }

    private ColumnConverterFactory() {
    }

    public static ColumnConverter getColumnConverter(Class columnType) {
        if (columnType_columnConverter_map.containsKey(columnType.getCanonicalName())) {
            return columnType_columnConverter_map.get(columnType.getCanonicalName());
        }
        if (ColumnConverter.class.isAssignableFrom(columnType)) {
            try {
                ColumnConverter columnConverter = (ColumnConverter)columnType.newInstance();
                if (columnConverter != null) {
                    columnType_columnConverter_map.put(columnType.getCanonicalName(), columnConverter);
                }
                return columnConverter;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static ColumnDbType getDbColumnType(Class columnType) {
        ColumnConverter converter = ColumnConverterFactory.getColumnConverter(columnType);
        if (converter != null) {
            return converter.getColumnDbType();
        }
        return ColumnDbType.TEXT;
    }

    public static void registerColumnConverter(Class columnType, ColumnConverter columnConverter) {
        columnType_columnConverter_map.put(columnType.getCanonicalName(), columnConverter);
    }

    public static boolean isSupportColumnConverter(Class columnType) {
        if (columnType_columnConverter_map.containsKey(columnType.getCanonicalName())) {
            return true;
        }
        if (ColumnConverter.class.isAssignableFrom(columnType)) {
            try {
                ColumnConverter columnConverter = (ColumnConverter)columnType.newInstance();
                if (columnConverter != null) {
                    columnType_columnConverter_map.put(columnType.getCanonicalName(), columnConverter);
                }
                return columnConverter == null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

