/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.table;

import android.text.TextUtils;
import com.lidroid.xutils.db.annotation.Check;
import com.lidroid.xutils.db.annotation.Column;
import com.lidroid.xutils.db.annotation.Id;
import com.lidroid.xutils.db.annotation.NotNull;
import com.lidroid.xutils.db.annotation.Transient;
import com.lidroid.xutils.db.annotation.Unique;
import com.lidroid.xutils.db.converter.ColumnConverter;
import com.lidroid.xutils.db.converter.ColumnConverterFactory;
import com.lidroid.xutils.db.sqlite.FinderLazyLoader;
import com.lidroid.xutils.db.sqlite.ForeignLazyLoader;
import com.lidroid.xutils.db.table.Finder;
import com.lidroid.xutils.db.table.Foreign;
import com.lidroid.xutils.util.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.List;

public class ColumnUtils {
    private static final HashSet<String> DB_PRIMITIVE_TYPES = new HashSet(14);

    static {
        DB_PRIMITIVE_TYPES.add(Integer.TYPE.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Long.TYPE.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Short.TYPE.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Byte.TYPE.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Float.TYPE.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Double.TYPE.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Integer.class.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Long.class.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Short.class.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Byte.class.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Float.class.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(Double.class.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(String.class.getCanonicalName());
        DB_PRIMITIVE_TYPES.add(byte[].class.getCanonicalName());
    }

    private ColumnUtils() {
    }

    public static boolean isDbPrimitiveType(Class<?> fieldType) {
        return DB_PRIMITIVE_TYPES.contains(fieldType.getCanonicalName());
    }

    public static Method getColumnGetMethod(Class<?> entityType, Field field) {
        String fieldName = field.getName();
        Method getMethod = null;
        if (field.getType() == Boolean.TYPE) {
            getMethod = ColumnUtils.getBooleanColumnGetMethod(entityType, fieldName);
        }
        if (getMethod == null) {
            String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                getMethod = entityType.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LogUtils.d(String.valueOf(methodName) + " not exist");
            }
        }
        if (getMethod == null && !Object.class.equals(entityType.getSuperclass())) {
            return ColumnUtils.getColumnGetMethod(entityType.getSuperclass(), field);
        }
        return getMethod;
    }

    public static Method getColumnSetMethod(Class<?> entityType, Field field) {
        String fieldName = field.getName();
        Method setMethod = null;
        if (field.getType() == Boolean.TYPE) {
            setMethod = ColumnUtils.getBooleanColumnSetMethod(entityType, field);
        }
        if (setMethod == null) {
            String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                setMethod = entityType.getDeclaredMethod(methodName, field.getType());
            }
            catch (NoSuchMethodException e) {
                LogUtils.d(String.valueOf(methodName) + " not exist");
            }
        }
        if (setMethod == null && !Object.class.equals(entityType.getSuperclass())) {
            return ColumnUtils.getColumnSetMethod(entityType.getSuperclass(), field);
        }
        return setMethod;
    }

    public static String getColumnNameByField(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && !TextUtils.isEmpty((CharSequence)column.column())) {
            return column.column();
        }
        Id id = field.getAnnotation(Id.class);
        if (id != null && !TextUtils.isEmpty((CharSequence)id.column())) {
            return id.column();
        }
        com.lidroid.xutils.db.annotation.Foreign foreign = field.getAnnotation(com.lidroid.xutils.db.annotation.Foreign.class);
        if (foreign != null && !TextUtils.isEmpty((CharSequence)foreign.column())) {
            return foreign.column();
        }
        com.lidroid.xutils.db.annotation.Finder finder = field.getAnnotation(com.lidroid.xutils.db.annotation.Finder.class);
        if (finder != null) {
            return field.getName();
        }
        return field.getName();
    }

    public static String getForeignColumnNameByField(Field field) {
        com.lidroid.xutils.db.annotation.Foreign foreign = field.getAnnotation(com.lidroid.xutils.db.annotation.Foreign.class);
        if (foreign != null) {
            return foreign.foreign();
        }
        return field.getName();
    }

    public static String getColumnDefaultValue(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && !TextUtils.isEmpty((CharSequence)column.defaultValue())) {
            return column.defaultValue();
        }
        return null;
    }

    public static boolean isTransient(Field field) {
        return field.getAnnotation(Transient.class) != null;
    }

    public static boolean isForeign(Field field) {
        return field.getAnnotation(com.lidroid.xutils.db.annotation.Foreign.class) != null;
    }

    public static boolean isFinder(Field field) {
        return field.getAnnotation(com.lidroid.xutils.db.annotation.Finder.class) != null;
    }

    public static boolean isUnique(Field field) {
        return field.getAnnotation(Unique.class) != null;
    }

    public static boolean isNotNull(Field field) {
        return field.getAnnotation(NotNull.class) != null;
    }

    public static String getCheck(Field field) {
        Check check = field.getAnnotation(Check.class);
        if (check != null) {
            return check.value();
        }
        return null;
    }

    public static Class<?> getForeignEntityType(Foreign foreignColumn) {
        Class result = foreignColumn.getColumnField().getType();
        if (result.equals(ForeignLazyLoader.class) || result.equals(List.class)) {
            result = (Class)((ParameterizedType)foreignColumn.getColumnField().getGenericType()).getActualTypeArguments()[0];
        }
        return result;
    }

    public static Class<?> getFinderTargetEntityType(Finder finderColumn) {
        Class result = finderColumn.getColumnField().getType();
        if (result.equals(FinderLazyLoader.class) || result.equals(List.class)) {
            result = (Class)((ParameterizedType)finderColumn.getColumnField().getGenericType()).getActualTypeArguments()[0];
        }
        return result;
    }

    public static Object convert2DbColumnValueIfNeeded(Object value) {
        Class<?> valueType;
        Object result = value;
        if (value != null && !ColumnUtils.isDbPrimitiveType(valueType = value.getClass())) {
            ColumnConverter converter = ColumnConverterFactory.getColumnConverter(valueType);
            result = converter != null ? converter.fieldValue2ColumnValue(value) : value;
        }
        return result;
    }

    private static boolean isStartWithIs(String fieldName) {
        return fieldName != null && fieldName.startsWith("is");
    }

    private static Method getBooleanColumnGetMethod(Class<?> entityType, String fieldName) {
        String methodName = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (ColumnUtils.isStartWithIs(fieldName)) {
            methodName = fieldName;
        }
        try {
            return entityType.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LogUtils.d(String.valueOf(methodName) + " not exist");
            return null;
        }
    }

    private static Method getBooleanColumnSetMethod(Class<?> entityType, Field field) {
        String fieldName = field.getName();
        String methodName = null;
        methodName = ColumnUtils.isStartWithIs(field.getName()) ? "set" + fieldName.substring(2, 3).toUpperCase() + fieldName.substring(3) : "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return entityType.getDeclaredMethod(methodName, field.getType());
        }
        catch (NoSuchMethodException e) {
            LogUtils.d(String.valueOf(methodName) + " not exist");
            return null;
        }
    }
}

