/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.table;

import android.text.TextUtils;
import com.lidroid.xutils.DbUtils;
import com.lidroid.xutils.db.table.Column;
import com.lidroid.xutils.db.table.Id;
import com.lidroid.xutils.db.table.TableUtils;
import java.util.HashMap;
import java.util.Map;

public class Table {
    private String tableName;
    private Id id;
    public final HashMap<String, Column> columnMap;
    private static final HashMap<String, Table> tableMap = new HashMap();
    private boolean checkedDatabase;

    private Table(Class<?> entityType) {
        this.tableName = TableUtils.getTableName(entityType);
        this.id = TableUtils.getId(entityType);
        this.columnMap = TableUtils.getColumnMap(entityType);
    }

    public static synchronized Table get(DbUtils db, Class<?> entityType) {
        String tableKey = String.valueOf(db.getDaoConfig().getDbName()) + "#" + entityType.getCanonicalName();
        Table table = tableMap.get(tableKey);
        if (table == null) {
            table = new Table(entityType);
            tableMap.put(tableKey, table);
        }
        return table;
    }

    public static synchronized void remove(DbUtils db, Class<?> entityType) {
        String tableKey = String.valueOf(db.getDaoConfig().getDbName()) + "#" + entityType.getCanonicalName();
        tableMap.remove(tableKey);
    }

    public static synchronized void remove(DbUtils db, String tableName) {
        if (tableMap.size() > 0) {
            String key = null;
            for (Map.Entry<String, Table> entry : tableMap.entrySet()) {
                Table table = entry.getValue();
                if (table != null && table.getTableName().equals(tableName) && (key = entry.getKey()).startsWith(String.valueOf(db.getDaoConfig().getDbName()) + "#")) break;
            }
            if (TextUtils.isEmpty(key)) {
                tableMap.remove(key);
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public Id getId() {
        return this.id;
    }

    public boolean isCheckedDatabase() {
        return this.checkedDatabase;
    }

    public void setCheckedDatabase(boolean checkedDatabase) {
        this.checkedDatabase = checkedDatabase;
    }
}

