/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.multipart.content;

import com.lidroid.xutils.http.client.multipart.content.AbstractContentBody;
import com.lidroid.xutils.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class InputStreamBody
extends AbstractContentBody {
    private final InputStream in;
    private final String filename;
    private long length;

    public InputStreamBody(InputStream in, long length, String filename, String mimeType) {
        super(mimeType);
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        this.in = in;
        this.filename = filename;
        this.length = length;
    }

    public InputStreamBody(InputStream in, long length, String filename) {
        this(in, length, filename, "application/octet-stream");
    }

    public InputStreamBody(InputStream in, long length) {
        this(in, length, "no_name", "application/octet-stream");
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = this.in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
                this.callBackInfo.pos += (long)l;
                if (this.callBackInfo.doCallBack(false)) continue;
                throw new InterruptedIOException("stop");
            }
            out.flush();
        }
        finally {
            IOUtils.closeQuietly(this.in);
        }
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

