/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.util.core;

import com.lidroid.xutils.util.LogUtils;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class SimpleSSLSocketFactory
extends SSLSocketFactory {
    private SSLContext sslContext = SSLContext.getInstance("TLS");
    private static KeyStore trustStore;
    private static SimpleSSLSocketFactory instance;

    static {
        try {
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
    }

    public static SimpleSSLSocketFactory getSocketFactory() {
        if (instance == null) {
            try {
                instance = new SimpleSSLSocketFactory();
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        }
        return instance;
    }

    private SimpleSSLSocketFactory() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        super(trustStore);
        X509TrustManager trustAllCerts = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
        this.sslContext.init(null, new TrustManager[]{trustAllCerts}, null);
        this.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket() throws IOException {
        return this.sslContext.getSocketFactory().createSocket();
    }

    public static /* bridge */ /* synthetic */ SSLSocketFactory getSocketFactory() {
        return SimpleSSLSocketFactory.getSocketFactory();
    }
}

