/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableUtils {
    private static Logger logger = LoggerFactory.getLogger(TableUtils.class);
    private static final FieldType[] noFieldTypes = new FieldType[0];

    private TableUtils() {
    }

    public static <T> int createTable(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        return TableUtils.createTable(connectionSource, dataClass, false);
    }

    public static <T> int createTableIfNotExists(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        return TableUtils.createTable(connectionSource, dataClass, true);
    }

    public static <T> int createTable(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        return TableUtils.createTable(connectionSource, tableConfig, false);
    }

    public static <T> int createTableIfNotExists(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        return TableUtils.createTable(connectionSource, tableConfig, true);
    }

    public static <T, ID> List<String> getCreateTableStatements(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        Object dao = DaoManager.createDao(connectionSource, dataClass);
        if (dao instanceof BaseDaoImpl) {
            return TableUtils.addCreateTableStatements(connectionSource, ((BaseDaoImpl)dao).getTableInfo(), false);
        }
        TableInfo tableInfo = new TableInfo(connectionSource, null, dataClass);
        return TableUtils.addCreateTableStatements(connectionSource, tableInfo, false);
    }

    public static <T, ID> List<String> getCreateTableStatements(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        Object dao = DaoManager.createDao(connectionSource, tableConfig);
        if (dao instanceof BaseDaoImpl) {
            return TableUtils.addCreateTableStatements(connectionSource, ((BaseDaoImpl)dao).getTableInfo(), false);
        }
        tableConfig.extractFieldTypes(connectionSource);
        TableInfo tableInfo = new TableInfo(connectionSource.getDatabaseType(), null, tableConfig);
        return TableUtils.addCreateTableStatements(connectionSource, tableInfo, false);
    }

    public static <T, ID> int dropTable(ConnectionSource connectionSource, Class<T> dataClass, boolean ignoreErrors) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        Object dao = DaoManager.createDao(connectionSource, dataClass);
        if (dao instanceof BaseDaoImpl) {
            return TableUtils.doDropTable(databaseType, connectionSource, ((BaseDaoImpl)dao).getTableInfo(), ignoreErrors);
        }
        TableInfo tableInfo = new TableInfo(connectionSource, null, dataClass);
        return TableUtils.doDropTable(databaseType, connectionSource, tableInfo, ignoreErrors);
    }

    public static <T, ID> int dropTable(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig, boolean ignoreErrors) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        Object dao = DaoManager.createDao(connectionSource, tableConfig);
        if (dao instanceof BaseDaoImpl) {
            return TableUtils.doDropTable(databaseType, connectionSource, ((BaseDaoImpl)dao).getTableInfo(), ignoreErrors);
        }
        tableConfig.extractFieldTypes(connectionSource);
        TableInfo tableInfo = new TableInfo(databaseType, null, tableConfig);
        return TableUtils.doDropTable(databaseType, connectionSource, tableInfo, ignoreErrors);
    }

    public static <T> int clearTable(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        String tableName = DatabaseTableConfig.extractTableName(dataClass);
        if (connectionSource.getDatabaseType().isEntityNamesMustBeUpCase()) {
            tableName = tableName.toUpperCase();
        }
        return TableUtils.clearTable(connectionSource, tableName);
    }

    public static <T> int clearTable(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        return TableUtils.clearTable(connectionSource, tableConfig.getTableName());
    }

    private static <T, ID> int createTable(ConnectionSource connectionSource, Class<T> dataClass, boolean ifNotExists) throws SQLException {
        Object dao = DaoManager.createDao(connectionSource, dataClass);
        if (dao instanceof BaseDaoImpl) {
            return TableUtils.doCreateTable(connectionSource, ((BaseDaoImpl)dao).getTableInfo(), ifNotExists);
        }
        TableInfo tableInfo = new TableInfo(connectionSource, null, dataClass);
        return TableUtils.doCreateTable(connectionSource, tableInfo, ifNotExists);
    }

    private static <T, ID> int createTable(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig, boolean ifNotExists) throws SQLException {
        Object dao = DaoManager.createDao(connectionSource, tableConfig);
        if (dao instanceof BaseDaoImpl) {
            return TableUtils.doCreateTable(connectionSource, ((BaseDaoImpl)dao).getTableInfo(), ifNotExists);
        }
        tableConfig.extractFieldTypes(connectionSource);
        TableInfo tableInfo = new TableInfo(connectionSource.getDatabaseType(), null, tableConfig);
        return TableUtils.doCreateTable(connectionSource, tableInfo, ifNotExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> int clearTable(ConnectionSource connectionSource, String tableName) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        StringBuilder sb = new StringBuilder(48);
        if (databaseType.isTruncateSupported()) {
            sb.append("TRUNCATE TABLE ");
        } else {
            sb.append("DELETE FROM ");
        }
        databaseType.appendEscapedEntityName(sb, tableName);
        String statement = sb.toString();
        logger.info("clearing table '{}' with '{}", (Object)tableName, (Object)statement);
        CompiledStatement compiledStmt = null;
        DatabaseConnection connection = connectionSource.getReadWriteConnection();
        try {
            compiledStmt = connection.compileStatement(statement, StatementBuilder.StatementType.EXECUTE, noFieldTypes, -1);
            int n = compiledStmt.runExecute();
            return n;
        }
        finally {
            if (compiledStmt != null) {
                compiledStmt.close();
            }
            connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T, ID> int doDropTable(DatabaseType databaseType, ConnectionSource connectionSource, TableInfo<T, ID> tableInfo, boolean ignoreErrors) throws SQLException {
        logger.info("dropping table '{}'", (Object)tableInfo.getTableName());
        ArrayList<String> statements = new ArrayList<String>();
        TableUtils.addDropIndexStatements(databaseType, tableInfo, statements);
        TableUtils.addDropTableStatements(databaseType, tableInfo, statements);
        DatabaseConnection connection = connectionSource.getReadWriteConnection();
        try {
            int n = TableUtils.doStatements(connection, "drop", statements, ignoreErrors, databaseType.isCreateTableReturnsNegative(), false);
            return n;
        }
        finally {
            connectionSource.releaseConnection(connection);
        }
    }

    private static <T, ID> void addDropIndexStatements(DatabaseType databaseType, TableInfo<T, ID> tableInfo, List<String> statements) {
        HashSet<String> indexSet = new HashSet<String>();
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            String uniqueIndexName;
            String indexName = fieldType.getIndexName();
            if (indexName != null) {
                indexSet.add(indexName);
            }
            if ((uniqueIndexName = fieldType.getUniqueIndexName()) == null) continue;
            indexSet.add(uniqueIndexName);
        }
        StringBuilder sb = new StringBuilder(48);
        for (String indexName : indexSet) {
            logger.info("dropping index '{}' for table '{}", (Object)indexName, (Object)tableInfo.getTableName());
            sb.append("DROP INDEX ");
            databaseType.appendEscapedEntityName(sb, indexName);
            statements.add(sb.toString());
            sb.setLength(0);
        }
    }

    private static <T, ID> void addCreateTableStatements(DatabaseType databaseType, TableInfo<T, ID> tableInfo, List<String> statements, List<String> queriesAfter, boolean ifNotExists) throws SQLException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE TABLE ");
        if (ifNotExists && databaseType.isCreateIfNotExistsSupported()) {
            sb.append("IF NOT EXISTS ");
        }
        databaseType.appendEscapedEntityName(sb, tableInfo.getTableName());
        sb.append(" (");
        ArrayList<String> additionalArgs = new ArrayList<String>();
        ArrayList<String> statementsBefore = new ArrayList<String>();
        ArrayList<String> statementsAfter = new ArrayList<String>();
        boolean first = true;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (fieldType.isForeignCollection()) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String columnDefinition = fieldType.getColumnDefinition();
            if (columnDefinition == null) {
                databaseType.appendColumnArg(tableInfo.getTableName(), sb, fieldType, additionalArgs, statementsBefore, statementsAfter, queriesAfter);
                continue;
            }
            databaseType.appendEscapedEntityName(sb, fieldType.getColumnName());
            sb.append(' ').append(columnDefinition).append(' ');
        }
        databaseType.addPrimaryKeySql(tableInfo.getFieldTypes(), additionalArgs, statementsBefore, statementsAfter, queriesAfter);
        databaseType.addUniqueComboSql(tableInfo.getFieldTypes(), additionalArgs, statementsBefore, statementsAfter, queriesAfter);
        for (String arg : additionalArgs) {
            sb.append(", ").append(arg);
        }
        sb.append(") ");
        databaseType.appendCreateTableSuffix(sb);
        statements.addAll(statementsBefore);
        statements.add(sb.toString());
        statements.addAll(statementsAfter);
        TableUtils.addCreateIndexStatements(databaseType, tableInfo, statements, ifNotExists, false);
        TableUtils.addCreateIndexStatements(databaseType, tableInfo, statements, ifNotExists, true);
    }

    private static <T, ID> void addCreateIndexStatements(DatabaseType databaseType, TableInfo<T, ID> tableInfo, List<String> statements, boolean ifNotExists, boolean unique) {
        HashMap<String, ArrayList<String>> indexMap = new HashMap<String, ArrayList<String>>();
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            String indexName = unique ? fieldType.getUniqueIndexName() : fieldType.getIndexName();
            if (indexName == null) continue;
            ArrayList<String> columnList = (ArrayList<String>)indexMap.get(indexName);
            if (columnList == null) {
                columnList = new ArrayList<String>();
                indexMap.put(indexName, columnList);
            }
            columnList.add(fieldType.getColumnName());
        }
        StringBuilder sb = new StringBuilder(128);
        for (Map.Entry indexEntry : indexMap.entrySet()) {
            logger.info("creating index '{}' for table '{}", indexEntry.getKey(), (Object)tableInfo.getTableName());
            sb.append("CREATE ");
            if (unique) {
                sb.append("UNIQUE ");
            }
            sb.append("INDEX ");
            if (ifNotExists && databaseType.isCreateIndexIfNotExistsSupported()) {
                sb.append("IF NOT EXISTS ");
            }
            databaseType.appendEscapedEntityName(sb, (String)indexEntry.getKey());
            sb.append(" ON ");
            databaseType.appendEscapedEntityName(sb, tableInfo.getTableName());
            sb.append(" ( ");
            boolean first = true;
            for (String columnName : (List)indexEntry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                databaseType.appendEscapedEntityName(sb, columnName);
            }
            sb.append(" )");
            statements.add(sb.toString());
            sb.setLength(0);
        }
    }

    private static <T, ID> void addDropTableStatements(DatabaseType databaseType, TableInfo<T, ID> tableInfo, List<String> statements) {
        ArrayList<String> statementsBefore = new ArrayList<String>();
        ArrayList<String> statementsAfter = new ArrayList<String>();
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            databaseType.dropColumnArg(fieldType, statementsBefore, statementsAfter);
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("DROP TABLE ");
        databaseType.appendEscapedEntityName(sb, tableInfo.getTableName());
        sb.append(' ');
        statements.addAll(statementsBefore);
        statements.add(sb.toString());
        statements.addAll(statementsAfter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T, ID> int doCreateTable(ConnectionSource connectionSource, TableInfo<T, ID> tableInfo, boolean ifNotExists) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        logger.info("creating table '{}'", (Object)tableInfo.getTableName());
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<String> queriesAfter = new ArrayList<String>();
        TableUtils.addCreateTableStatements(databaseType, tableInfo, statements, queriesAfter, ifNotExists);
        DatabaseConnection connection = connectionSource.getReadWriteConnection();
        try {
            int stmtC = TableUtils.doStatements(connection, "create", statements, false, databaseType.isCreateTableReturnsNegative(), databaseType.isCreateTableReturnsZero());
            int n = stmtC += TableUtils.doCreateTestQueries(connection, databaseType, queriesAfter);
            return n;
        }
        finally {
            connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doStatements(DatabaseConnection connection, String label, Collection<String> statements, boolean ignoreErrors, boolean returnsNegative, boolean expectingZero) throws SQLException {
        int stmtC = 0;
        for (String statement : statements) {
            int rowC;
            block12: {
                rowC = 0;
                CompiledStatement compiledStmt = null;
                try {
                    compiledStmt = connection.compileStatement(statement, StatementBuilder.StatementType.EXECUTE, noFieldTypes, -1);
                    rowC = compiledStmt.runExecute();
                    logger.info("executed {} table statement changed {} rows: {}", (Object)label, (Object)rowC, (Object)statement);
                }
                catch (SQLException e) {
                    if (ignoreErrors) {
                        logger.info("ignoring {} error '{}' for statement: {}", (Object)label, (Object)e, (Object)statement);
                        break block12;
                    }
                    throw SqlExceptionUtil.create("SQL statement failed: " + statement, e);
                }
                finally {
                    if (compiledStmt != null) {
                        compiledStmt.close();
                    }
                }
            }
            if (rowC < 0) {
                if (!returnsNegative) {
                    throw new SQLException("SQL statement " + statement + " updated " + rowC + " rows, we were expecting >= 0");
                }
            } else if (rowC > 0 && expectingZero) {
                throw new SQLException("SQL statement updated " + rowC + " rows, we were expecting == 0: " + statement);
            }
            ++stmtC;
        }
        return stmtC;
    }

    private static int doCreateTestQueries(DatabaseConnection connection, DatabaseType databaseType, List<String> queriesAfter) throws SQLException {
        int stmtC = 0;
        for (String query : queriesAfter) {
            CompiledStatement compiledStmt = null;
            try {
                compiledStmt = connection.compileStatement(query, StatementBuilder.StatementType.SELECT, noFieldTypes, -1);
                DatabaseResults results = compiledStmt.runQuery(null);
                int rowC = 0;
                boolean isThereMore = results.first();
                while (isThereMore) {
                    ++rowC;
                    isThereMore = results.next();
                }
                logger.info("executing create table after-query got {} results: {}", rowC, (Object)query);
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create("executing create table after-query failed: " + query, e);
            }
            finally {
                if (compiledStmt != null) {
                    compiledStmt.close();
                }
            }
            ++stmtC;
        }
        return stmtC;
    }

    private static <T, ID> List<String> addCreateTableStatements(ConnectionSource connectionSource, TableInfo<T, ID> tableInfo, boolean ifNotExists) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<String> queriesAfter = new ArrayList<String>();
        TableUtils.addCreateTableStatements(connectionSource.getDatabaseType(), tableInfo, statements, queriesAfter, ifNotExists);
        return statements;
    }
}

