/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.license;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import java.net.NetworkInterface;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LicenseDevice {
    private static final String KEY_FACE = "com.baidu.face";
    private static final String KEY_IMEI = "com.baidu.face.i";
    private static final String KEY_DEVICE = "com.baidu.face.deviceid";

    private static String getImei(Context context) {
        String imei = "";
        String enimei = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)KEY_IMEI);
        if (!TextUtils.isEmpty((CharSequence)enimei)) {
            try {
                String deimei = LicenseDevice.decrypt(enimei, "01251500ascfacei");
                if (!TextUtils.isEmpty((CharSequence)deimei) && deimei.length() == 15) {
                    imei = deimei;
                    return imei;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(imei = LicenseDevice.getDeviceCode(context)))) {
            try {
                enimei = LicenseDevice.encrypt(imei, "01251500ascfacei");
                Settings.System.putString((ContentResolver)context.getContentResolver(), (String)KEY_IMEI, (String)enimei);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imei;
    }

    public static String getDeviceID(Context context) {
        String deviceid = "";
        String androidid = LicenseDevice.getAndroidID(context);
        if (Build.VERSION.SDK_INT >= 23) {
            deviceid = LicenseDevice.md5((KEY_FACE + androidid).getBytes());
            return deviceid;
        }
        try {
            String imei = LicenseDevice.getImei(context);
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                String endevice = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)KEY_DEVICE);
                if (!TextUtils.isEmpty((CharSequence)endevice)) {
                    try {
                        String dedevice = LicenseDevice.decrypt(endevice, imei + 1);
                        if (!TextUtils.isEmpty((CharSequence)dedevice)) {
                            deviceid = dedevice;
                            return deviceid;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                deviceid = LicenseDevice.md5((imei + androidid + UUID.randomUUID()).getBytes());
                endevice = LicenseDevice.encrypt(deviceid, imei + 1);
                Settings.System.putString((ContentResolver)context.getContentResolver(), (String)KEY_DEVICE, (String)endevice);
                return deviceid;
            }
            String macAddress = LicenseDevice.getMacAddr();
            deviceid = LicenseDevice.md5((macAddress + androidid).getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deviceid;
    }

    public static String getDeviceCode(Context context) {
        String imei = "";
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null && context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
                imei = tm.getDeviceId();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return imei;
    }

    public static String getAndroidID(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getMacAddr() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "";
                }
                StringBuilder sbuilder = new StringBuilder();
                for (byte b : macBytes) {
                    sbuilder.append(String.format("%02X:", b));
                }
                if (sbuilder.length() > 0) {
                    sbuilder.deleteCharAt(sbuilder.length() - 1);
                }
                return sbuilder.toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public static String md5(byte[] message) {
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest(message);
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                int i = b & 0xFF;
                if (i < 16) {
                    hex.append('0');
                }
                hex.append(Integer.toHexString(i));
            }
            return hex.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String encrypt(String sSrc, String sKey) throws Exception {
        byte[] raw = sKey.getBytes();
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec("01251500ascfacei".getBytes());
        cipher.init(1, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(sSrc.getBytes());
        return Base64.encodeToString((byte[])encrypted, (int)2);
    }

    public static String decrypt(String sSrc, String sKey) throws Exception {
        try {
            byte[] raw = sKey.getBytes("ASCII");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec("01251500ascfacei".getBytes());
            cipher.init(2, (Key)skeySpec, iv);
            byte[] encrypted1 = Base64.decode((String)sSrc, (int)2);
            try {
                byte[] original = cipher.doFinal(encrypted1);
                String originalString = new String(original);
                return originalString;
            }
            catch (Exception e) {
                return "";
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            return "";
        }
    }
}

