/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.iflytek.speech.UnderstanderResult;

public interface SpeechUnderstanderListener
extends IInterface {
    public void onVolumeChanged(int var1, byte[] var2) throws RemoteException;

    public void onBeginOfSpeech() throws RemoteException;

    public void onEndOfSpeech() throws RemoteException;

    public void onResult(UnderstanderResult var1) throws RemoteException;

    public void onError(int var1) throws RemoteException;

    public void onEvent(int var1, int var2, int var3, Bundle var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements SpeechUnderstanderListener {
        private static final String DESCRIPTOR = "com.iflytek.speech.SpeechUnderstanderListener";
        static final int TRANSACTION_onVolumeChanged = 1;
        static final int TRANSACTION_onBeginOfSpeech = 2;
        static final int TRANSACTION_onEndOfSpeech = 3;
        static final int TRANSACTION_onResult = 4;
        static final int TRANSACTION_onError = 5;
        static final int TRANSACTION_onEvent = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static SpeechUnderstanderListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof SpeechUnderstanderListener) {
                return (SpeechUnderstanderListener)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n2, Parcel parcel, Parcel parcel2, int n3) throws RemoteException {
            switch (n2) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    byte[] byArray = parcel.createByteArray();
                    this.onVolumeChanged(n4, byArray);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onBeginOfSpeech();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onEndOfSpeech();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    UnderstanderResult understanderResult = 0 != parcel.readInt() ? (UnderstanderResult)UnderstanderResult.CREATOR.createFromParcel(parcel) : null;
                    this.onResult(understanderResult);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    this.onError(n5);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    Bundle bundle = 0 != parcel.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.onEvent(n6, n7, n8, bundle);
                    return true;
                }
            }
            return super.onTransact(n2, parcel, parcel2, n3);
        }

        private static class Proxy
        implements SpeechUnderstanderListener {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onVolumeChanged(int n2, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(1, parcel, null, 1);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    parcel.recycle();
                    throw throwable;
                }
                parcel.recycle();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onBeginOfSpeech() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, null, 1);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    parcel.recycle();
                    throw throwable;
                }
                parcel.recycle();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEndOfSpeech() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, null, 1);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    parcel.recycle();
                    throw throwable;
                }
                parcel.recycle();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResult(UnderstanderResult understanderResult) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (understanderResult != null) {
                        parcel.writeInt(1);
                        understanderResult.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, null, 1);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    parcel.recycle();
                    throw throwable;
                }
                parcel.recycle();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    this.mRemote.transact(5, parcel, null, 1);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    parcel.recycle();
                    throw throwable;
                }
                parcel.recycle();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(int n2, int n3, int n4, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, null, 1);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    parcel.recycle();
                    throw throwable;
                }
                parcel.recycle();
            }
        }
    }
}

