/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import java.util.Map;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslException;

public class ExternalSaslClient
implements SaslClient {
    private String m_authorizationId = "";
    private String m_protocol = "";
    private String m_serverName = "";
    private Map m_props;
    private CallbackHandler m_cbh;
    private int m_state;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_VALID_SERVER_RESPONSE = 1;
    private static final int STATE_INVALID_SERVER_RESPONSE = 2;
    private static final int STATE_DISPOSED = 3;

    public static SaslClient getClient(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) {
        return new ExternalSaslClient(string, string2, string3, map, callbackHandler);
    }

    private ExternalSaslClient(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) {
        this.m_authorizationId = string;
        this.m_protocol = string2;
        this.m_serverName = string3;
        this.m_props = map;
        this.m_cbh = callbackHandler;
        this.m_state = 0;
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.m_state == 1 || this.m_state == 2 || this.m_state == 3;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new IllegalStateException("unwrap: QOP has neither integrity nor privacy>");
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new IllegalStateException("wrap: QOP has neither integrity nor privacy>");
    }

    @Override
    public Object getNegotiatedProperty(String string) {
        if (this.m_state != 1) {
            throw new IllegalStateException("getNegotiatedProperty: authentication exchange not complete.");
        }
        if ("javax.security.sasl.qop".equals(string)) {
            return "auth";
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        if (this.m_state != 3) {
            this.m_state = 3;
        }
    }

    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        byte[] byArray2 = null;
        switch (this.m_state) {
            case 0: {
                if (byArray.length != 0) {
                    this.m_state = 2;
                    throw new SaslException("Unexpected non-zero length response.");
                }
                this.m_state = 1;
                break;
            }
            case 2: {
                throw new SaslException("Authentication sequence is complete");
            }
            case 3: {
                throw new SaslException("Client has been disposed");
            }
            default: {
                throw new SaslException("Unknown client state.");
            }
        }
        return byArray2;
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }
}

