/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.sasl;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.NameCallback;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;

public class UsernameHashedPasswordCallbackHandler
implements CallbackHandler {
    private String user;
    private char[] pwchars;

    public UsernameHashedPasswordCallbackHandler(String string, String string2) throws Exception {
        this.user = string;
        this.pwchars = UsernameHashedPasswordCallbackHandler.getHash(string2);
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Serializable serializable;
            if (callbackArray[i] instanceof NameCallback) {
                serializable = (NameCallback)callbackArray[i];
                ((NameCallback)serializable).setName(this.user);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                serializable = (PasswordCallback)callbackArray[i];
                ((PasswordCallback)serializable).setPassword(this.pwchars);
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i]);
        }
    }

    private void clearPassword() {
        if (this.pwchars != null) {
            for (int i = 0; i < this.pwchars.length; ++i) {
                this.pwchars[i] = '\u0000';
            }
            this.pwchars = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clearPassword();
        super.finalize();
    }

    public static char[] getHash(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray = string.getBytes("utf-8");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        for (byte by : byArray) {
            messageDigest.update(by);
        }
        byte[] byArray2 = messageDigest.digest();
        char[] cArray = new char[byArray2.length];
        int n = 0;
        for (byte by : byArray2) {
            cArray[n++] = (char)by;
        }
        return cArray;
    }
}

