/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;

public class AccountManager
extends Manager {
    private static final Map<XMPPConnection, AccountManager> INSTANCES = new WeakHashMap<XMPPConnection, AccountManager>();
    private Registration info = null;
    private boolean accountCreationSupported = false;

    public static synchronized AccountManager getInstance(XMPPConnection xMPPConnection) {
        AccountManager accountManager = INSTANCES.get(xMPPConnection);
        if (accountManager == null) {
            accountManager = new AccountManager(xMPPConnection);
        }
        return accountManager;
    }

    private AccountManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        INSTANCES.put(xMPPConnection, this);
    }

    void setSupportsAccountCreation(boolean bl) {
        this.accountCreationSupported = bl;
    }

    public boolean supportsAccountCreation() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.accountCreationSupported) {
            return true;
        }
        if (this.info == null) {
            this.getRegistrationInfo();
            this.accountCreationSupported = this.info.getType() != IQ.Type.ERROR;
        }
        return this.accountCreationSupported;
    }

    public Collection<String> getAccountAttributes() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Map<String, String> map;
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        if ((map = this.info.getAttributes()) != null) {
            return Collections.unmodifiableSet(map.keySet());
        }
        return Collections.emptySet();
    }

    public String getAccountAttribute(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getAttributes().get(string);
    }

    public String getAccountInstructions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getInstructions();
    }

    public void createAccount(String string, String string2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : this.getAccountAttributes()) {
            hashMap.put(string3, "");
        }
        this.createAccount(string, string2, hashMap);
    }

    public void createAccount(String string, String string2, Map<String, String> map) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.connection().getServiceName());
        map.put("username", string);
        map.put("password", string2);
        registration.setAttributes(map);
        this.connection().createPacketCollectorAndSend(registration).nextResultOrThrow();
    }

    public void changePassword(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.connection().getServiceName());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("username", StringUtils.parseName(this.connection().getUser()));
        hashMap.put("password", string);
        registration.setAttributes(hashMap);
        this.connection().createPacketCollectorAndSend(registration).nextResultOrThrow();
    }

    public void deleteAccount() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.connection().getServiceName());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("remove", "");
        registration.setAttributes(hashMap);
        this.connection().createPacketCollectorAndSend(registration).nextResultOrThrow();
    }

    private synchronized void getRegistrationInfo() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration registration = new Registration();
        registration.setTo(this.connection().getServiceName());
        this.info = (Registration)this.connection().createPacketCollectorAndSend(registration).nextResultOrThrow();
    }
}

