/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class Chat {
    private ChatManager chatManager;
    private String threadID;
    private String participant;
    private final Set<MessageListener> listeners = new CopyOnWriteArraySet<MessageListener>();

    Chat(ChatManager chatManager, String string, String string2) {
        this.chatManager = chatManager;
        this.participant = string;
        this.threadID = string2;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public String getParticipant() {
        return this.participant;
    }

    public void sendMessage(String string) throws XMPPException, SmackException.NotConnectedException {
        Message message = new Message(this.participant, Message.Type.chat);
        message.setThread(this.threadID);
        message.setBody(string);
        this.chatManager.sendMessage(this, message);
    }

    public void sendMessage(Message message) throws SmackException.NotConnectedException {
        message.setTo(this.participant);
        message.setType(Message.Type.chat);
        message.setThread(this.threadID);
        this.chatManager.sendMessage(this, message);
    }

    public void addMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            return;
        }
        this.listeners.add(messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.listeners.remove(messageListener);
    }

    public void close() {
        this.chatManager.closeChat(this);
        this.listeners.clear();
    }

    public Collection<MessageListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public PacketCollector createCollector() {
        return this.chatManager.createPacketCollector(this);
    }

    void deliver(Message message) {
        message.setThread(this.threadID);
        for (MessageListener messageListener : this.listeners) {
            messageListener.processMessage(this, message);
        }
    }

    public String toString() {
        return "Chat [(participant=" + this.participant + "), (thread=" + this.threadID + ")]";
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.threadID.hashCode();
        n = n * 31 + this.participant.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof Chat && this.threadID.equals(((Chat)object).getThreadID()) && this.participant.equals(((Chat)object).getParticipant());
    }
}

