/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;

public class PacketCollector {
    private static final Logger LOGGER = Logger.getLogger(PacketCollector.class.getName());
    private PacketFilter packetFilter;
    private ArrayBlockingQueue<Packet> resultQueue;
    private XMPPConnection connection;
    private boolean cancelled = false;

    protected PacketCollector(XMPPConnection xMPPConnection, PacketFilter packetFilter) {
        this(xMPPConnection, packetFilter, SmackConfiguration.getPacketCollectorSize());
    }

    protected PacketCollector(XMPPConnection xMPPConnection, PacketFilter packetFilter, int n) {
        this.connection = xMPPConnection;
        this.packetFilter = packetFilter;
        this.resultQueue = new ArrayBlockingQueue(n);
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.connection.removePacketCollector(this);
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public Packet pollResult() {
        return this.resultQueue.poll();
    }

    public Packet nextResultBlockForever() {
        Packet packet = null;
        while (packet == null) {
            try {
                packet = this.resultQueue.take();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.FINE, "nextResultBlockForever was interrupted", interruptedException);
            }
        }
        return packet;
    }

    public Packet nextResult() {
        return this.nextResult(this.connection.getPacketReplyTimeout());
    }

    public Packet nextResult(long l) {
        Packet packet = null;
        long l2 = l;
        long l3 = System.currentTimeMillis();
        while (packet == null && l2 > 0L) {
            try {
                packet = this.resultQueue.poll(l2, TimeUnit.MILLISECONDS);
                l2 = l - (System.currentTimeMillis() - l3);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.FINE, "nextResult was interrupted", interruptedException);
            }
        }
        return packet;
    }

    public Packet nextResultOrThrow() throws SmackException.NoResponseException, XMPPException.XMPPErrorException {
        return this.nextResultOrThrow(this.connection.getPacketReplyTimeout());
    }

    public Packet nextResultOrThrow(long l) throws SmackException.NoResponseException, XMPPException.XMPPErrorException {
        Packet packet = this.nextResult(l);
        this.cancel();
        if (packet == null) {
            throw new SmackException.NoResponseException();
        }
        XMPPError xMPPError = packet.getError();
        if (xMPPError != null) {
            throw new XMPPException.XMPPErrorException(xMPPError);
        }
        return packet;
    }

    protected void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            while (!this.resultQueue.offer(packet)) {
                this.resultQueue.poll();
            }
        }
    }
}

