/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.RosterStore;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

public class Roster {
    private static final Logger LOGGER = Logger.getLogger(Roster.class.getName());
    private static final PacketFilter ROSTER_PUSH_FILTER = new AndFilter(new PacketTypeFilter(RosterPacket.class), new IQTypeFilter(IQ.Type.SET));
    private static final PacketFilter PRESENCE_PACKET_FILTER = new PacketTypeFilter(Presence.class);
    private static SubscriptionMode defaultSubscriptionMode = SubscriptionMode.accept_all;
    private final XMPPConnection connection;
    private final RosterStore rosterStore;
    private final Map<String, RosterGroup> groups = new ConcurrentHashMap<String, RosterGroup>();
    private final Map<String, RosterEntry> entries = new ConcurrentHashMap<String, RosterEntry>();
    private final List<RosterEntry> unfiledEntries = new CopyOnWriteArrayList<RosterEntry>();
    private final List<RosterListener> rosterListeners = new CopyOnWriteArrayList<RosterListener>();
    private final Map<String, Map<String, Presence>> presenceMap = new ConcurrentHashMap<String, Map<String, Presence>>();
    boolean rosterInitialized = false;
    private final PresencePacketListener presencePacketListener = new PresencePacketListener();
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    Roster(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.rosterStore = xMPPConnection.getConfiguration().getRosterStore();
        xMPPConnection.addPacketListener(new RosterPushListener(), ROSTER_PUSH_FILTER);
        xMPPConnection.addPacketListener(this.presencePacketListener, PRESENCE_PACKET_FILTER);
        xMPPConnection.addConnectionListener(new AbstractConnectionListener(){

            @Override
            public void connectionClosed() {
                try {
                    Roster.this.setOfflinePresences();
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    LOGGER.log(Level.SEVERE, "Not connected exception", notConnectedException);
                }
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                try {
                    Roster.this.setOfflinePresences();
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    LOGGER.log(Level.SEVERE, "Not connected exception", exception);
                }
            }
        });
        if (xMPPConnection.isAuthenticated()) {
            try {
                this.reload();
            }
            catch (SmackException smackException) {
                LOGGER.log(Level.SEVERE, "Could not reload Roster", smackException);
            }
        }
        xMPPConnection.addConnectionListener(new AbstractConnectionListener(){

            @Override
            public void authenticated(XMPPConnection xMPPConnection) {
                if (xMPPConnection.isAnonymous()) {
                    return;
                }
                if (!xMPPConnection.getConfiguration().isRosterLoadedAtLogin()) {
                    return;
                }
                try {
                    Roster.this.reload();
                }
                catch (SmackException smackException) {
                    LOGGER.log(Level.SEVERE, "Could not reload Roster", smackException);
                    return;
                }
            }
        });
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void reload() throws SmackException.NotLoggedInException, SmackException.NotConnectedException {
        if (!this.connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket rosterPacket = new RosterPacket();
        if (this.rosterStore != null && this.connection.isRosterVersioningSupported()) {
            rosterPacket.setVersion(this.rosterStore.getRosterVersion());
        }
        IQReplyFilter iQReplyFilter = new IQReplyFilter(rosterPacket, this.connection);
        this.connection.addPacketListener(new RosterResultListener(), iQReplyFilter);
        this.connection.sendPacket(rosterPacket);
    }

    public void addRosterListener(RosterListener rosterListener) {
        if (!this.rosterListeners.contains(rosterListener)) {
            this.rosterListeners.add(rosterListener);
        }
    }

    public void removeRosterListener(RosterListener rosterListener) {
        this.rosterListeners.remove(rosterListener);
    }

    public RosterGroup createGroup(String string) {
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (this.groups.containsKey(string)) {
            return this.groups.get(string);
        }
        RosterGroup rosterGroup = new RosterGroup(string, this.connection);
        this.groups.put(string, rosterGroup);
        return rosterGroup;
    }

    public void createEntry(String string, String string2, String[] stringArray) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!this.connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.SET);
        RosterPacket.Item item = new RosterPacket.Item(string, string2);
        if (stringArray != null) {
            for (String string3 : stringArray) {
                if (string3 == null || string3.trim().length() <= 0) continue;
                item.addGroupName(string3);
            }
        }
        rosterPacket.addRosterItem(item);
        this.connection.createPacketCollectorAndSend(rosterPacket).nextResultOrThrow();
        Presence presence = new Presence(Presence.Type.subscribe);
        presence.setTo(string);
        this.connection.sendPacket(presence);
    }

    public void removeEntry(RosterEntry rosterEntry) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!this.connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (!this.entries.containsKey(rosterEntry.getUser())) {
            return;
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.SET);
        RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
        item.setItemType(RosterPacket.ItemType.remove);
        rosterPacket.addRosterItem(item);
        this.connection.createPacketCollectorAndSend(rosterPacket).nextResultOrThrow();
    }

    public int getEntryCount() {
        return this.getEntries().size();
    }

    public Collection<RosterEntry> getEntries() {
        HashSet<RosterEntry> hashSet = new HashSet<RosterEntry>();
        for (RosterGroup rosterGroup : this.getGroups()) {
            hashSet.addAll(rosterGroup.getEntries());
        }
        hashSet.addAll(this.unfiledEntries);
        return Collections.unmodifiableCollection(hashSet);
    }

    public int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public Collection<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableList(this.unfiledEntries);
    }

    public RosterEntry getEntry(String string) {
        if (string == null) {
            return null;
        }
        return this.entries.get(string.toLowerCase(Locale.US));
    }

    public boolean contains(String string) {
        return this.getEntry(string) != null;
    }

    public RosterGroup getGroup(String string) {
        return this.groups.get(string);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Presence getPresence(String string) {
        String string2 = this.getPresenceMapKey(StringUtils.parseBareAddress(string));
        Map<String, Presence> map = this.presenceMap.get(string2);
        if (map == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        Presence presence = null;
        for (String string3 : map.keySet()) {
            Presence.Mode mode;
            Presence presence2 = map.get(string3);
            if (!presence2.isAvailable()) continue;
            if (presence == null || presence2.getPriority() > presence.getPriority()) {
                presence = presence2;
                continue;
            }
            if (presence2.getPriority() != presence.getPriority()) continue;
            Presence.Mode mode2 = presence2.getMode();
            if (mode2 == null) {
                mode2 = Presence.Mode.available;
            }
            if ((mode = presence.getMode()) == null) {
                mode = Presence.Mode.available;
            }
            if (mode2.compareTo(mode) >= 0) continue;
            presence = presence2;
        }
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        return presence;
    }

    public Presence getPresenceResource(String string) {
        String string2 = this.getPresenceMapKey(string);
        String string3 = StringUtils.parseResource(string);
        Map<String, Presence> map = this.presenceMap.get(string2);
        if (map == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        Presence presence = map.get(string3);
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        return presence;
    }

    public List<Presence> getPresences(String string) {
        List<Presence> list;
        String string2 = this.getPresenceMapKey(string);
        Map<String, Presence> map = this.presenceMap.get(string2);
        if (map == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            list = Arrays.asList(presence);
        } else {
            ArrayList<Presence> arrayList = new ArrayList<Presence>();
            for (Presence presence : map.values()) {
                if (!presence.isAvailable()) continue;
                arrayList.add(presence);
            }
            if (!arrayList.isEmpty()) {
                list = arrayList;
            } else {
                Presence presence = new Presence(Presence.Type.unavailable);
                presence.setFrom(string);
                list = Arrays.asList(presence);
            }
        }
        return Collections.unmodifiableList(list);
    }

    private String getPresenceMapKey(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (!this.contains(string)) {
            string2 = StringUtils.parseBareAddress(string);
        }
        return string2.toLowerCase(Locale.US);
    }

    private void setOfflinePresences() throws SmackException.NotConnectedException {
        for (String string : this.presenceMap.keySet()) {
            Map<String, Presence> map = this.presenceMap.get(string);
            if (map == null) continue;
            for (String string2 : map.keySet()) {
                Presence presence = new Presence(Presence.Type.unavailable);
                presence.setFrom(string + "/" + string2);
                this.presencePacketListener.processPacket(presence);
            }
        }
    }

    private void fireRosterChangedEvent(Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        for (RosterListener rosterListener : this.rosterListeners) {
            if (!collection.isEmpty()) {
                rosterListener.entriesAdded(collection);
            }
            if (!collection2.isEmpty()) {
                rosterListener.entriesUpdated(collection2);
            }
            if (collection3.isEmpty()) continue;
            rosterListener.entriesDeleted(collection3);
        }
    }

    private void fireRosterPresenceEvent(Presence presence) {
        for (RosterListener rosterListener : this.rosterListeners) {
            rosterListener.presenceChanged(presence);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addUpdateEntry(Collection<String> collection, Collection<String> collection2, Collection<String> collection3, RosterPacket.Item item, RosterEntry rosterEntry) {
        Object object2;
        RosterEntry rosterEntry2 = this.entries.put(item.getUser(), rosterEntry);
        if (rosterEntry2 == null) {
            collection.add(item.getUser());
        } else {
            object2 = RosterEntry.toRosterItem(rosterEntry2);
            if (!rosterEntry2.equalsDeep(rosterEntry) || !item.getGroupNames().equals(((RosterPacket.Item)object2).getGroupNames())) {
                collection2.add(item.getUser());
            } else {
                collection3.add(item.getUser());
            }
        }
        if (item.getGroupNames().isEmpty()) {
            this.unfiledEntries.remove(rosterEntry);
            this.unfiledEntries.add(rosterEntry);
        } else {
            this.unfiledEntries.remove(rosterEntry);
        }
        object2 = new ArrayList();
        for (String iterator2 : item.getGroupNames()) {
            void var10_12;
            object2.add(iterator2);
            RosterGroup rosterGroup = this.getGroup(iterator2);
            if (rosterGroup == null) {
                RosterGroup rosterGroup2 = this.createGroup(iterator2);
                this.groups.put(iterator2, rosterGroup2);
            }
            var10_12.addEntryLocal(rosterEntry);
        }
        ArrayList arrayList = new ArrayList();
        for (RosterGroup rosterGroup : this.getGroups()) {
            arrayList.add(rosterGroup.getName());
        }
        arrayList.removeAll((Collection<?>)object2);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RosterGroup rosterGroup = this.getGroup(string);
            rosterGroup.removeEntryLocal(rosterEntry);
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(string);
        }
    }

    private void deleteEntry(Collection<String> collection, RosterEntry rosterEntry) {
        String string = rosterEntry.getUser();
        this.entries.remove(string);
        this.unfiledEntries.remove(rosterEntry);
        this.presenceMap.remove(StringUtils.parseBareAddress(string));
        collection.add(string);
        for (Map.Entry<String, RosterGroup> entry : this.groups.entrySet()) {
            RosterGroup rosterGroup = entry.getValue();
            rosterGroup.removeEntryLocal(rosterEntry);
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(entry.getKey());
        }
    }

    private void removeEmptyGroups() {
        for (RosterGroup rosterGroup : this.getGroups()) {
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(rosterGroup.getName());
        }
    }

    private static boolean hasValidSubscriptionType(RosterPacket.Item item) {
        return item.getItemType().equals((Object)RosterPacket.ItemType.none) || item.getItemType().equals((Object)RosterPacket.ItemType.from) || item.getItemType().equals((Object)RosterPacket.ItemType.to) || item.getItemType().equals((Object)RosterPacket.ItemType.both);
    }

    private class RosterPushListener
    implements PacketListener {
        private RosterPushListener() {
        }

        @Override
        public void processPacket(Packet packet) throws SmackException.NotConnectedException {
            RosterPacket rosterPacket = (RosterPacket)packet;
            String string = rosterPacket.getVersion();
            String string2 = StringUtils.parseBareAddress(Roster.this.connection.getUser());
            if (rosterPacket.getFrom() != null && !rosterPacket.getFrom().equals(string2)) {
                LOGGER.warning("Ignoring roster push with a non matching 'from' ourJid=" + string2 + " from=" + rosterPacket.getFrom());
                return;
            }
            Collection<RosterPacket.Item> collection = rosterPacket.getRosterItems();
            if (collection.size() != 1) {
                LOGGER.warning("Ignoring roster push with not exaclty one entry. size=" + collection.size());
                return;
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            RosterPacket.Item item = collection.iterator().next();
            RosterEntry rosterEntry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, Roster.this.connection);
            if (item.getItemType().equals((Object)RosterPacket.ItemType.remove)) {
                Roster.this.deleteEntry(arrayList3, rosterEntry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.removeEntry(rosterEntry.getUser(), string);
                }
            } else if (Roster.hasValidSubscriptionType(item)) {
                Roster.this.addUpdateEntry(arrayList, arrayList2, arrayList4, item, rosterEntry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.addEntry(item, string);
                }
            }
            Roster.this.connection.sendPacket(IQ.createResultIQ(rosterPacket));
            Roster.this.removeEmptyGroups();
            Roster.this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
        }
    }

    private class RosterResultListener
    implements PacketListener {
        private RosterResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPacket(Packet packet) {
            Object object;
            Roster.this.connection.removePacketListener(this);
            IQ iQ = (IQ)packet;
            if (!iQ.getType().equals(IQ.Type.RESULT)) {
                LOGGER.severe("Roster result IQ not of type result. Packet: " + iQ.toXML());
                return;
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            if (packet instanceof RosterPacket) {
                Object object22;
                object = (RosterPacket)packet;
                String string = ((RosterPacket)object).getVersion();
                ArrayList<RosterPacket.Item> arrayList5 = new ArrayList<RosterPacket.Item>();
                for (RosterPacket.Item object32 : ((RosterPacket)object).getRosterItems()) {
                    if (!Roster.hasValidSubscriptionType(object32)) continue;
                    arrayList5.add(object32);
                }
                for (RosterPacket.Item item : arrayList5) {
                    object22 = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, Roster.this.connection);
                    Roster.this.addUpdateEntry(arrayList, arrayList2, arrayList4, item, (RosterEntry)object22);
                }
                HashSet hashSet = new HashSet();
                for (Object object22 : Roster.this.entries.values()) {
                    hashSet.add(((RosterEntry)object22).getUser());
                }
                hashSet.removeAll(arrayList);
                hashSet.removeAll(arrayList2);
                hashSet.removeAll(arrayList4);
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    object22 = (String)iterator.next();
                    Roster.this.deleteEntry(arrayList3, (RosterEntry)Roster.this.entries.get(object22));
                }
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.resetEntries(arrayList5, string);
                }
                Roster.this.removeEmptyGroups();
            } else {
                for (RosterPacket.Item item : Roster.this.rosterStore.getEntries()) {
                    RosterEntry rosterEntry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, Roster.this.connection);
                    Roster.this.addUpdateEntry(arrayList, arrayList2, arrayList4, item, rosterEntry);
                }
            }
            Roster.this.rosterInitialized = true;
            object = Roster.this;
            synchronized (object) {
                Roster.this.notifyAll();
            }
            Roster.this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
        }
    }

    private class PresencePacketListener
    implements PacketListener {
        private PresencePacketListener() {
        }

        @Override
        public void processPacket(Packet packet) throws SmackException.NotConnectedException {
            Presence presence = (Presence)packet;
            String string = presence.getFrom();
            String string2 = Roster.this.getPresenceMapKey(string);
            if (presence.getType() == Presence.Type.available) {
                Map<String, Presence> map;
                if (Roster.this.presenceMap.get(string2) == null) {
                    map = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(string2, map);
                } else {
                    map = (Map)Roster.this.presenceMap.get(string2);
                }
                map.remove("");
                map.put(StringUtils.parseResource(string), presence);
                RosterEntry rosterEntry = (RosterEntry)Roster.this.entries.get(string2);
                if (rosterEntry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            } else if (presence.getType() == Presence.Type.unavailable) {
                Object object;
                if ("".equals(StringUtils.parseResource(string))) {
                    if (Roster.this.presenceMap.get(string2) == null) {
                        object = new ConcurrentHashMap();
                        Roster.this.presenceMap.put(string2, object);
                    } else {
                        object = (Map)Roster.this.presenceMap.get(string2);
                    }
                    object.put("", presence);
                } else if (Roster.this.presenceMap.get(string2) != null) {
                    object = (Map)Roster.this.presenceMap.get(string2);
                    object.put(StringUtils.parseResource(string), presence);
                }
                object = (RosterEntry)Roster.this.entries.get(string2);
                if (object != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            } else if (presence.getType() == Presence.Type.subscribe) {
                Presence presence2 = null;
                switch (Roster.this.subscriptionMode) {
                    case accept_all: {
                        presence2 = new Presence(Presence.Type.subscribed);
                        break;
                    }
                    case reject_all: {
                        presence2 = new Presence(Presence.Type.unsubscribed);
                        break;
                    }
                }
                if (presence2 != null) {
                    presence2.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(presence2);
                }
            } else if (presence.getType() == Presence.Type.unsubscribe) {
                if (Roster.this.subscriptionMode != SubscriptionMode.manual) {
                    Presence presence3 = new Presence(Presence.Type.unsubscribed);
                    presence3.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(presence3);
                }
            } else if (presence.getType() == Presence.Type.error && "".equals(StringUtils.parseResource(string))) {
                Map<String, Presence> map;
                if (!Roster.this.presenceMap.containsKey(string2)) {
                    map = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(string2, map);
                } else {
                    map = (Map)Roster.this.presenceMap.get(string2);
                    map.clear();
                }
                map.put("", presence);
                RosterEntry rosterEntry = (RosterEntry)Roster.this.entries.get(string2);
                if (rosterEntry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            }
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }
}

