/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.dnsjava.DNSJavaResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.ResolverConfig;

public class SmackAndroid {
    private static final Logger LOGGER = Logger.getLogger(SmackAndroid.class.getName());
    private static SmackAndroid sSmackAndroid = null;
    private BroadcastReceiver mConnectivityChangedReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            LOGGER.fine("ConnectivityChange received, calling ResolverConfig.refresh() and Lookup.refreshDefault() in new Thread");
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ResolverConfig.refresh();
                    Lookup.refreshDefault();
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    };
    private static boolean receiverRegistered = false;
    private Context mCtx;

    private SmackAndroid(Context context) {
        this.mCtx = context.getApplicationContext();
        DNSUtil.setDNSResolver(DNSJavaResolver.getInstance());
    }

    public static synchronized SmackAndroid init(Context context) {
        if (sSmackAndroid == null) {
            sSmackAndroid = new SmackAndroid(context);
        }
        sSmackAndroid.maybeRegisterReceiver();
        return sSmackAndroid;
    }

    public synchronized void onDestroy() {
        LOGGER.fine("onDestroy: receiverRegistered=" + receiverRegistered);
        if (receiverRegistered) {
            this.mCtx.unregisterReceiver(this.mConnectivityChangedReceiver);
            receiverRegistered = false;
        }
    }

    private void maybeRegisterReceiver() {
        LOGGER.fine("maybeRegisterReceiver: receiverRegistered=" + receiverRegistered);
        if (!receiverRegistered) {
            this.mCtx.registerReceiver(this.mConnectivityChangedReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            receiverRegistered = true;
        }
    }
}

