/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import org.jivesoftware.smack.compression.Java7ZlibInputOutputStream;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.parsing.ExceptionThrowingCallback;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.FileUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class SmackConfiguration {
    private static final String SMACK_VERSION;
    private static final String DEFAULT_CONFIG_FILE = "classpath:org.jivesoftware.smack/smack-config.xml";
    private static final Logger LOGGER;
    private static int defaultPacketReplyTimeout;
    private static int packetCollectorSize;
    private static List<String> defaultMechs;
    private static Set<String> disabledSmackClasses;
    private static final List<XMPPInputOutputStream> compressionHandlers;
    public static boolean DEBUG_ENABLED;
    private static ParsingExceptionCallback defaultCallback;
    private static HostnameVerifier defaultHostnameVerififer;

    public static String getVersion() {
        return SMACK_VERSION;
    }

    public static int getDefaultPacketReplyTimeout() {
        if (defaultPacketReplyTimeout <= 0) {
            defaultPacketReplyTimeout = 5000;
        }
        return defaultPacketReplyTimeout;
    }

    public static void setDefaultPacketReplyTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        defaultPacketReplyTimeout = n;
    }

    public static int getPacketCollectorSize() {
        return packetCollectorSize;
    }

    public static void setPacketCollectorSize(int n) {
        packetCollectorSize = n;
    }

    public static void addSaslMech(String string) {
        if (!defaultMechs.contains(string)) {
            defaultMechs.add(string);
        }
    }

    public static void addSaslMechs(Collection<String> collection) {
        for (String string : collection) {
            SmackConfiguration.addSaslMech(string);
        }
    }

    public static void removeSaslMech(String string) {
        defaultMechs.remove(string);
    }

    public static void removeSaslMechs(Collection<String> collection) {
        defaultMechs.removeAll(collection);
    }

    public static List<String> getSaslMechs() {
        return Collections.unmodifiableList(defaultMechs);
    }

    public static void setDefaultParsingExceptionCallback(ParsingExceptionCallback parsingExceptionCallback) {
        defaultCallback = parsingExceptionCallback;
    }

    public static ParsingExceptionCallback getDefaultParsingExceptionCallback() {
        return defaultCallback;
    }

    public static void addCompressionHandler(XMPPInputOutputStream xMPPInputOutputStream) {
        compressionHandlers.add(xMPPInputOutputStream);
    }

    public static List<XMPPInputOutputStream> getCompresionHandlers() {
        ArrayList<XMPPInputOutputStream> arrayList = new ArrayList<XMPPInputOutputStream>(compressionHandlers.size());
        for (XMPPInputOutputStream xMPPInputOutputStream : compressionHandlers) {
            if (!xMPPInputOutputStream.isSupported()) continue;
            arrayList.add(xMPPInputOutputStream);
        }
        return arrayList;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        defaultHostnameVerififer = hostnameVerifier;
    }

    static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerififer;
    }

    public static void processConfigFile(InputStream inputStream, Collection<Exception> collection) throws Exception {
        SmackConfiguration.processConfigFile(inputStream, collection, SmackConfiguration.class.getClassLoader());
    }

    public static void processConfigFile(InputStream inputStream, Collection<Exception> collection, ClassLoader classLoader) throws Exception {
        XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
        xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        xmlPullParser.setInput(inputStream, "UTF-8");
        int n = xmlPullParser.getEventType();
        do {
            if (n != 2) continue;
            if (xmlPullParser.getName().equals("startupClasses")) {
                SmackConfiguration.parseClassesToLoad(xmlPullParser, false, collection, classLoader);
                continue;
            }
            if (!xmlPullParser.getName().equals("optionalStartupClasses")) continue;
            SmackConfiguration.parseClassesToLoad(xmlPullParser, true, collection, classLoader);
        } while ((n = xmlPullParser.next()) != 1);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Error while closing config file input stream", iOException);
        }
    }

    private static void parseClassesToLoad(XmlPullParser xmlPullParser, boolean bl, Collection<Exception> collection, ClassLoader classLoader) throws XmlPullParserException, IOException, Exception {
        String string;
        int n;
        String string2 = xmlPullParser.getName();
        do {
            n = xmlPullParser.next();
            string = xmlPullParser.getName();
            if (n != 2 || !"className".equals(string)) continue;
            String string3 = xmlPullParser.nextText();
            if (disabledSmackClasses.contains(string3)) {
                LOGGER.info("Not loading disabled Smack class " + string3);
                continue;
            }
            try {
                SmackConfiguration.loadSmackClass(string3, bl, classLoader);
            }
            catch (Exception exception) {
                if (collection != null) {
                    collection.add(exception);
                    continue;
                }
                throw exception;
            }
        } while (n != 3 || !string2.equals(string));
    }

    private static void loadSmackClass(String string, boolean bl, ClassLoader classLoader) throws Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Level level = bl ? Level.FINE : Level.WARNING;
            LOGGER.log(level, "A startup class '" + string + "' could not be loaded.");
            if (!bl) {
                throw classNotFoundException;
            }
            return;
        }
        if (SmackInitializer.class.isAssignableFrom(clazz)) {
            SmackInitializer smackInitializer = (SmackInitializer)clazz.newInstance();
            List<Exception> list = smackInitializer.initialize();
            if (list.size() == 0) {
                LOGGER.log(Level.FINE, "Loaded SmackInitializer " + string);
            } else {
                for (Exception exception : list) {
                    LOGGER.log(Level.SEVERE, "Exception in loadSmackClass", exception);
                }
            }
        } else {
            LOGGER.log(Level.FINE, "Loaded " + string);
        }
    }

    static {
        Object object;
        String string;
        Object object2;
        LOGGER = Logger.getLogger(SmackConfiguration.class.getName());
        defaultPacketReplyTimeout = 5000;
        packetCollectorSize = 5000;
        defaultMechs = new ArrayList<String>();
        disabledSmackClasses = new HashSet<String>();
        compressionHandlers = new ArrayList<XMPPInputOutputStream>(2);
        DEBUG_ENABLED = false;
        try {
            object2 = new BufferedReader(new InputStreamReader(FileUtils.getStreamForUrl("classpath:org.jivesoftware.smack/version", null)));
            string = ((BufferedReader)object2).readLine();
            try {
                ((BufferedReader)object2).close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "IOException closing stream", iOException);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Could not determine Smack version", exception);
            string = "unkown";
        }
        SMACK_VERSION = string;
        object2 = System.getProperty("smack.disabledClasses");
        if (object2 != null) {
            for (String string2 : object = ((String)object2).split(",")) {
                disabledSmackClasses.add(string2);
            }
        }
        try {
            FileUtils.addLines("classpath:org.jivesoftware.smack/disabledClasses", disabledSmackClasses);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        try {
            object = Class.forName("org.jivesoftware.smack.CustomSmackConfiguration");
            Field field = ((Class)object).getField("DISABLED_SMACK_CLASSES");
            String[] stringArray = (String[])field.get(null);
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    disabledSmackClasses.add(string3);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            object = FileUtils.getStreamForUrl(DEFAULT_CONFIG_FILE, null);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        try {
            SmackConfiguration.processConfigFile((InputStream)object, null);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        compressionHandlers.add(new Java7ZlibInputOutputStream());
        try {
            DEBUG_ENABLED = Boolean.getBoolean("smack.debugEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DNSUtil.init();
        defaultCallback = new ExceptionThrowingCallback();
    }
}

