/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.dns.HostAddress;

public class SmackException
extends Exception {
    private static final long serialVersionUID = 1844674365368214457L;

    public SmackException(Throwable throwable) {
        super(throwable);
    }

    public SmackException(String string) {
        super(string);
    }

    public SmackException(String string, Throwable throwable) {
        super(string, throwable);
    }

    protected SmackException() {
    }

    public static class ResourceBindingNotOfferedException
    extends SmackException {
        private static final long serialVersionUID = 2346934138253437571L;
    }

    public static class FeatureNotSupportedException
    extends SmackException {
        private static final long serialVersionUID = 4713404802621452016L;
        private final String feature;
        private final String jid;

        public FeatureNotSupportedException(String string) {
            this(string, (String)null);
        }

        public FeatureNotSupportedException(String string, String string2) {
            super(string + " not supported" + (string2 == null ? "" : " by '" + string2 + "'"));
            this.jid = string2;
            this.feature = string;
        }

        public String getFeature() {
            return this.feature;
        }

        public String getJid() {
            return this.jid;
        }
    }

    public static class ConnectionException
    extends SmackException {
        private static final long serialVersionUID = 1686944201672697996L;
        private final List<HostAddress> failedAddresses;

        public ConnectionException(Throwable throwable) {
            super(throwable);
            this.failedAddresses = new ArrayList<HostAddress>(0);
        }

        public ConnectionException(List<HostAddress> list) {
            this.failedAddresses = list;
        }

        public List<HostAddress> getFailedAddresses() {
            return this.failedAddresses;
        }
    }

    public static class SecurityRequiredException
    extends SmackException {
        private static final long serialVersionUID = 384291845029773545L;
    }

    public static class IllegalStateChangeException
    extends SmackException {
        private static final long serialVersionUID = -1766023961577168927L;
    }

    public static class NotConnectedException
    extends SmackException {
        private static final long serialVersionUID = 9197980400776001173L;
    }

    public static class AlreadyLoggedInException
    extends SmackException {
        private static final long serialVersionUID = 5011416918049935231L;
    }

    public static class NotLoggedInException
    extends SmackException {
        private static final long serialVersionUID = 3216216839100019278L;
    }

    public static class NoResponseException
    extends SmackException {
        private static final long serialVersionUID = -6523363748984543636L;
    }
}

