/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.Locale;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;

public class FromMatchesFilter
implements PacketFilter {
    private String address;
    private boolean matchBareJID = false;

    public FromMatchesFilter(String string, boolean bl) {
        this.address = string == null ? null : string.toLowerCase(Locale.US);
        this.matchBareJID = bl;
    }

    public static FromMatchesFilter create(String string) {
        return new FromMatchesFilter(string, "".equals(StringUtils.parseResource(string)));
    }

    public static FromMatchesFilter createBare(String string) {
        string = string == null ? null : StringUtils.parseBareAddress(string);
        return new FromMatchesFilter(string, true);
    }

    public static FromMatchesFilter createFull(String string) {
        return new FromMatchesFilter(string, false);
    }

    @Override
    public boolean accept(Packet packet) {
        String string = packet.getFrom();
        if (string == null) {
            return this.address == null;
        }
        string = string.toLowerCase(Locale.US);
        if (this.matchBareJID) {
            string = StringUtils.parseBareAddress(string);
        }
        return string.equals(this.address);
    }

    public String toString() {
        String string = this.matchBareJID ? "bare" : "full";
        return "FromMatchesFilter (" + string + "): " + this.address;
    }
}

