/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;

public class IQReplyFilter
implements PacketFilter {
    private static final Logger LOGGER = Logger.getLogger(IQReplyFilter.class.getName());
    private final PacketFilter iqAndIdFilter;
    private final OrFilter fromFilter;
    private final String to;
    private final String local;
    private final String server;
    private final String packetId;

    public IQReplyFilter(IQ iQ, XMPPConnection xMPPConnection) {
        this.to = iQ.getTo();
        this.local = xMPPConnection.getUser() == null ? null : xMPPConnection.getUser().toLowerCase(Locale.US);
        this.server = xMPPConnection.getServiceName().toLowerCase(Locale.US);
        this.packetId = iQ.getPacketID();
        OrFilter orFilter = new OrFilter(new IQTypeFilter(IQ.Type.ERROR), new IQTypeFilter(IQ.Type.RESULT));
        PacketIDFilter packetIDFilter = new PacketIDFilter(iQ);
        this.iqAndIdFilter = new AndFilter(orFilter, packetIDFilter);
        this.fromFilter = new OrFilter();
        this.fromFilter.addFilter(FromMatchesFilter.createFull(this.to));
        if (this.to == null) {
            if (this.local != null) {
                this.fromFilter.addFilter(FromMatchesFilter.createBare(this.local));
            }
            this.fromFilter.addFilter(FromMatchesFilter.createFull(this.server));
        } else if (this.local != null && this.to.toLowerCase(Locale.US).equals(StringUtils.parseBareAddress(this.local))) {
            this.fromFilter.addFilter(FromMatchesFilter.createFull(null));
        }
    }

    @Override
    public boolean accept(Packet packet) {
        if (!this.iqAndIdFilter.accept(packet)) {
            return false;
        }
        if (this.fromFilter.accept(packet)) {
            return true;
        }
        String string = String.format("Rejected potentially spoofed reply to IQ-packet. Filter settings: packetId=%s, to=%s, local=%s, server=%s. Received packet with from=%s", this.packetId, this.to, this.local, this.server, packet.getFrom());
        LOGGER.log(Level.WARNING, string, packet);
        return false;
    }
}

