/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.initializer;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.initializer.SmackAndOsgiInitializer;
import org.jivesoftware.smack.provider.ProviderFileLoader;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.FileUtils;

public abstract class UrlInitializer
extends SmackAndOsgiInitializer {
    private static final Logger LOGGER = Logger.getLogger(UrlInitializer.class.getName());

    @Override
    public List<Exception> initialize() {
        return this.initialize(this.getClass().getClassLoader());
    }

    @Override
    public List<Exception> initialize(ClassLoader classLoader) {
        Object object;
        InputStream inputStream;
        LinkedList<Exception> linkedList = new LinkedList<Exception>();
        String string = this.getProvidersUrl();
        if (string != null) {
            try {
                inputStream = FileUtils.getStreamForUrl(string, classLoader);
                if (inputStream != null) {
                    LOGGER.log(Level.FINE, "Loading providers for providerUrl [" + string + "]");
                    object = new ProviderFileLoader(inputStream, classLoader);
                    ProviderManager.addLoader((ProviderLoader)object);
                    linkedList.addAll(((ProviderFileLoader)object).getLoadingExceptions());
                } else {
                    LOGGER.log(Level.WARNING, "No input stream created for " + string);
                    linkedList.add(new IOException("No input stream created for " + string));
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Error trying to load provider file " + string, exception);
                linkedList.add(exception);
            }
        }
        if ((object = this.getConfigUrl()) != null) {
            try {
                inputStream = FileUtils.getStreamForUrl((String)object, classLoader);
                SmackConfiguration.processConfigFile(inputStream, linkedList, classLoader);
            }
            catch (Exception exception) {
                linkedList.add(exception);
            }
        }
        return linkedList;
    }

    protected String getProvidersUrl() {
        return null;
    }

    protected String getConfigUrl() {
        return null;
    }
}

