/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class IQ
extends Packet {
    private Type type = Type.GET;

    public IQ() {
    }

    public IQ(IQ iQ) {
        super(iQ);
        this.type = iQ.getType();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type == null ? Type.GET : type;
    }

    @Override
    public CharSequence toXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement("iq");
        this.addCommonAttributes(xmlStringBuilder);
        if (this.type == null) {
            xmlStringBuilder.attribute("type", "get");
        } else {
            xmlStringBuilder.attribute("type", this.type.toString());
        }
        xmlStringBuilder.rightAngelBracket();
        xmlStringBuilder.optAppend(this.getChildElementXML());
        XMPPError xMPPError = this.getError();
        if (xMPPError != null) {
            xmlStringBuilder.append(xMPPError.toXML());
        }
        xmlStringBuilder.closeElement("iq");
        return xmlStringBuilder;
    }

    public abstract CharSequence getChildElementXML();

    public static IQ createResultIQ(IQ iQ) {
        if (iQ.getType() != Type.GET && iQ.getType() != Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + iQ.toXML());
        }
        IQ iQ2 = new IQ(){

            @Override
            public String getChildElementXML() {
                return null;
            }
        };
        iQ2.setType(Type.RESULT);
        iQ2.setPacketID(iQ.getPacketID());
        iQ2.setFrom(iQ.getTo());
        iQ2.setTo(iQ.getFrom());
        return iQ2;
    }

    public static IQ createErrorResponse(final IQ iQ, XMPPError xMPPError) {
        if (iQ.getType() != Type.GET && iQ.getType() != Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + iQ.toXML());
        }
        IQ iQ2 = new IQ(){

            @Override
            public CharSequence getChildElementXML() {
                return iQ.getChildElementXML();
            }
        };
        iQ2.setType(Type.ERROR);
        iQ2.setPacketID(iQ.getPacketID());
        iQ2.setFrom(iQ.getTo());
        iQ2.setTo(iQ.getFrom());
        iQ2.setError(xMPPError);
        return iQ2;
    }

    public static class Type {
        public static final Type GET = new Type("get");
        public static final Type SET = new Type("set");
        public static final Type RESULT = new Type("result");
        public static final Type ERROR = new Type("error");
        private String value;

        public static Type fromString(String string) {
            if (string == null) {
                return null;
            }
            string = string.toLowerCase(Locale.US);
            if (GET.toString().equals(string)) {
                return GET;
            }
            if (SET.toString().equals(string)) {
                return SET;
            }
            if (ERROR.toString().equals(string)) {
                return ERROR;
            }
            if (RESULT.toString().equals(string)) {
                return RESULT;
            }
            return null;
        }

        private Type(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

