/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class RosterPacket
extends IQ {
    private final List<Item> rosterItems = new ArrayList<Item>();
    private String rosterVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterItem(Item item) {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            this.rosterItems.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRosterItemCount() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return this.rosterItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Item> getRosterItems() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.rosterItems));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getChildElementXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement("query");
        xmlStringBuilder.xmlnsAttribute("jabber:iq:roster");
        xmlStringBuilder.optAttribute("ver", this.rosterVersion);
        xmlStringBuilder.rightAngelBracket();
        List<Item> list = this.rosterItems;
        synchronized (list) {
            for (Item item : this.rosterItems) {
                xmlStringBuilder.append(item.toXML());
            }
        }
        xmlStringBuilder.closeElement("query");
        return xmlStringBuilder;
    }

    public String getVersion() {
        return this.rosterVersion;
    }

    public void setVersion(String string) {
        this.rosterVersion = string;
    }

    public static enum ItemType {
        none,
        to,
        from,
        both,
        remove;

    }

    public static enum ItemStatus {
        subscribe,
        unsubscribe;

        public static final ItemStatus SUBSCRIPTION_PENDING;
        public static final ItemStatus UNSUBSCRIPTION_PENDING;

        public static ItemStatus fromString(String string) {
            if (string == null) {
                return null;
            }
            try {
                return ItemStatus.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        static {
            SUBSCRIPTION_PENDING = subscribe;
            UNSUBSCRIPTION_PENDING = unsubscribe;
        }
    }

    public static class Item {
        private String user;
        private String name;
        private ItemType itemType;
        private ItemStatus itemStatus;
        private final Set<String> groupNames;

        public Item(String string, String string2) {
            this.user = string.toLowerCase(Locale.US);
            this.name = string2;
            this.itemType = null;
            this.itemStatus = null;
            this.groupNames = new CopyOnWriteArraySet<String>();
        }

        public String getUser() {
            return this.user;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public void setItemType(ItemType itemType) {
            this.itemType = itemType;
        }

        public ItemStatus getItemStatus() {
            return this.itemStatus;
        }

        public void setItemStatus(ItemStatus itemStatus) {
            this.itemStatus = itemStatus;
        }

        public Set<String> getGroupNames() {
            return Collections.unmodifiableSet(this.groupNames);
        }

        public void addGroupName(String string) {
            this.groupNames.add(string);
        }

        public void removeGroupName(String string) {
            this.groupNames.remove(string);
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item jid=\"").append(StringUtils.escapeForXML(this.user)).append("\"");
            if (this.name != null) {
                stringBuilder.append(" name=\"").append(StringUtils.escapeForXML(this.name)).append("\"");
            }
            if (this.itemType != null) {
                stringBuilder.append(" subscription=\"").append((Object)this.itemType).append("\"");
            }
            if (this.itemStatus != null) {
                stringBuilder.append(" ask=\"").append((Object)this.itemStatus).append("\"");
            }
            stringBuilder.append(">");
            for (String string : this.groupNames) {
                stringBuilder.append("<group>").append(StringUtils.escapeForXML(string)).append("</group>");
            }
            stringBuilder.append("</item>");
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.groupNames == null ? 0 : this.groupNames.hashCode());
            n = 31 * n + (this.itemStatus == null ? 0 : this.itemStatus.hashCode());
            n = 31 * n + (this.itemType == null ? 0 : this.itemType.hashCode());
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            n = 31 * n + (this.user == null ? 0 : this.user.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Item item = (Item)object;
            if (this.groupNames == null ? item.groupNames != null : !this.groupNames.equals(item.groupNames)) {
                return false;
            }
            if (this.itemStatus != item.itemStatus) {
                return false;
            }
            if (this.itemType != item.itemType) {
                return false;
            }
            if (this.name == null ? item.name != null : !this.name.equals(item.name)) {
                return false;
            }
            return !(this.user == null ? item.user != null : !this.user.equals(item.user));
        }
    }
}

