/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.StringUtils;

class HTTPProxySocketFactory
extends SocketFactory {
    private ProxyInfo proxy;
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("HTTP/\\S+\\s(\\d+)\\s(.*)\\s*");

    public HTTPProxySocketFactory(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.httpProxifiedSocket(string, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.httpProxifiedSocket(string, n);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.httpProxifiedSocket(inetAddress.getHostAddress(), n);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.httpProxifiedSocket(inetAddress.getHostAddress(), n);
    }

    private Socket httpProxifiedSocket(String string, int n) throws IOException {
        Object object;
        String string2;
        String string3 = this.proxy.getProxyAddress();
        int n2 = this.proxy.getProxyPort();
        Socket socket = new Socket(string3, n2);
        String string4 = "CONNECT " + string + ":" + n;
        String string5 = this.proxy.getProxyUsername();
        if (string5 == null) {
            string2 = "";
        } else {
            object = this.proxy.getProxyPassword();
            string2 = "\r\nProxy-Authorization: Basic " + StringUtils.encodeBase64(string5 + ":" + (String)object);
        }
        socket.getOutputStream().write((string4 + " HTTP/1.1\r\nHost: " + string4 + string2 + "\r\n\r\n").getBytes("UTF-8"));
        object = socket.getInputStream();
        StringBuilder stringBuilder = new StringBuilder(100);
        int n3 = 0;
        do {
            char c = (char)((InputStream)object).read();
            stringBuilder.append(c);
            if (stringBuilder.length() > 1024) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Recieved header of >1024 characters from " + string3 + ", cancelling connection");
            }
            if (c == '\uffffffff') {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP);
            }
            if ((n3 == 0 || n3 == 2) && c == '\r') {
                ++n3;
                continue;
            }
            if ((n3 == 1 || n3 == 3) && c == '\n') {
                ++n3;
                continue;
            }
            n3 = 0;
        } while (n3 != 4);
        if (n3 != 4) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Never received blank line from " + string3 + ", cancelling connection");
        }
        String string6 = stringBuilder.toString();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string6));
        String string7 = bufferedReader.readLine();
        if (string7 == null) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Empty proxy response from " + string3 + ", cancelling");
        }
        Matcher matcher = RESPONSE_PATTERN.matcher(string7);
        if (!matcher.matches()) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Unexpected proxy response from " + string3 + ": " + string7);
        }
        int n4 = Integer.parseInt(matcher.group(1));
        if (n4 != 200) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP);
        }
        return socket;
    }
}

