/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.parsing.UnparsablePacket;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class PacketReader {
    private Thread readerThread;
    private XMPPTCPConnection connection;
    private XmlPullParser parser;
    private volatile boolean lastFeaturesParsed;
    volatile boolean done;

    protected PacketReader(XMPPTCPConnection xMPPTCPConnection) throws SmackException {
        this.connection = xMPPTCPConnection;
        this.init();
    }

    protected void init() throws SmackException {
        this.done = false;
        this.lastFeaturesParsed = false;
        this.readerThread = new Thread(){

            @Override
            public void run() {
                PacketReader.this.parsePackets(this);
            }
        };
        this.readerThread.setName("Smack Packet Reader (" + this.connection.getConnectionCounter() + ")");
        this.readerThread.setDaemon(true);
        this.resetParser();
    }

    public synchronized void startup() throws SmackException.NoResponseException, IOException {
        this.readerThread.start();
        try {
            this.wait(this.connection.getPacketReplyTimeout());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.lastFeaturesParsed) {
            this.connection.throwConnectionExceptionOrNoResponse();
        }
    }

    public void shutdown() {
        this.done = true;
    }

    private void resetParser() throws SmackException {
        try {
            this.parser = PacketParserUtils.newXmppParser();
            this.parser.setInput(this.connection.getReader());
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new SmackException(xmlPullParserException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePackets(Thread thread) {
        block43: {
            try {
                int n = this.parser.getEventType();
                do {
                    if (n == 2) {
                        UnparsablePacket unparsablePacket;
                        String string;
                        int n2 = this.parser.getDepth();
                        ParsingExceptionCallback parsingExceptionCallback = this.connection.getParsingExceptionCallback();
                        if (this.parser.getName().equals("message")) {
                            Message message;
                            try {
                                message = PacketParserUtils.parseMessage(this.parser);
                            }
                            catch (Exception exception) {
                                string = PacketParserUtils.parseContentDepth(this.parser, n2);
                                unparsablePacket = new UnparsablePacket(string, exception);
                                if (parsingExceptionCallback != null) {
                                    parsingExceptionCallback.handleUnparsablePacket(unparsablePacket);
                                }
                                n = this.parser.next();
                                continue;
                            }
                            this.connection.processPacket(message);
                        } else if (this.parser.getName().equals("iq")) {
                            IQ iQ;
                            try {
                                iQ = PacketParserUtils.parseIQ(this.parser, this.connection);
                            }
                            catch (Exception exception) {
                                string = PacketParserUtils.parseContentDepth(this.parser, n2);
                                unparsablePacket = new UnparsablePacket(string, exception);
                                if (parsingExceptionCallback != null) {
                                    parsingExceptionCallback.handleUnparsablePacket(unparsablePacket);
                                }
                                n = this.parser.next();
                                continue;
                            }
                            this.connection.processPacket(iQ);
                        } else if (this.parser.getName().equals("presence")) {
                            Presence presence;
                            try {
                                presence = PacketParserUtils.parsePresence(this.parser);
                            }
                            catch (Exception exception) {
                                string = PacketParserUtils.parseContentDepth(this.parser, n2);
                                unparsablePacket = new UnparsablePacket(string, exception);
                                if (parsingExceptionCallback != null) {
                                    parsingExceptionCallback.handleUnparsablePacket(unparsablePacket);
                                }
                                n = this.parser.next();
                                continue;
                            }
                            this.connection.processPacket(presence);
                        } else if (this.parser.getName().equals("stream")) {
                            if ("jabber:client".equals(this.parser.getNamespace(null))) {
                                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                    if (!this.parser.getAttributeName(i).equals("id")) continue;
                                    this.connection.connectionID = this.parser.getAttributeValue(i);
                                }
                            }
                        } else {
                            if (this.parser.getName().equals("error")) {
                                throw new XMPPException.StreamErrorException(PacketParserUtils.parseStreamError(this.parser));
                            }
                            if (this.parser.getName().equals("features")) {
                                this.parseFeatures(this.parser);
                            } else if (this.parser.getName().equals("proceed")) {
                                this.connection.proceedTLSReceived();
                                this.resetParser();
                            } else if (this.parser.getName().equals("failure")) {
                                String string2 = this.parser.getNamespace(null);
                                if ("urn:ietf:params:xml:ns:xmpp-tls".equals(string2)) {
                                    throw new Exception("TLS negotiation has failed");
                                }
                                if ("http://jabber.org/protocol/compress".equals(string2)) {
                                    this.connection.streamCompressionNegotiationDone();
                                } else {
                                    SASLMechanism.SASLFailure sASLFailure = PacketParserUtils.parseSASLFailure(this.parser);
                                    this.connection.processPacket(sASLFailure);
                                    this.connection.getSASLAuthentication().authenticationFailed(sASLFailure);
                                }
                            } else if (this.parser.getName().equals("challenge")) {
                                String string3 = this.parser.nextText();
                                this.connection.processPacket(new SASLMechanism.Challenge(string3));
                                this.connection.getSASLAuthentication().challengeReceived(string3);
                            } else if (this.parser.getName().equals("success")) {
                                this.connection.processPacket(new SASLMechanism.Success(this.parser.nextText()));
                                this.connection.packetWriter.openStream();
                                this.resetParser();
                                this.connection.getSASLAuthentication().authenticated();
                            } else if (this.parser.getName().equals("compressed")) {
                                this.connection.startStreamCompression();
                                this.resetParser();
                            }
                        }
                    } else if (n == 3 && this.parser.getName().equals("stream")) {
                        this.connection.disconnect();
                    }
                    n = this.parser.next();
                } while (!this.done && n != 1 && thread == this.readerThread);
            }
            catch (Exception exception) {
                if (this.done || this.connection.isSocketClosed()) break block43;
                PacketReader packetReader = this;
                synchronized (packetReader) {
                    this.notify();
                }
                this.connection.notifyConnectionError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFeatures(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl3) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("starttls")) {
                    bl = true;
                    continue;
                }
                if (xmlPullParser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms(xmlPullParser));
                    continue;
                }
                if (xmlPullParser.getName().equals("bind")) {
                    this.connection.serverRequiresBinding();
                    continue;
                }
                if (xmlPullParser.getName().equals("c")) {
                    String string = xmlPullParser.getAttributeValue(null, "node");
                    String string2 = xmlPullParser.getAttributeValue(null, "ver");
                    if (string2 == null || string == null) continue;
                    String string3 = string + "#" + string2;
                    this.connection.setServiceCapsNode(string3);
                    continue;
                }
                if (xmlPullParser.getName().equals("session")) {
                    this.connection.serverSupportsSession();
                    continue;
                }
                if (xmlPullParser.getName().equals("ver")) {
                    if (!xmlPullParser.getNamespace().equals("urn:xmpp:features:rosterver")) continue;
                    this.connection.setRosterVersioningSupported();
                    continue;
                }
                if (xmlPullParser.getName().equals("compression")) {
                    this.connection.setAvailableCompressionMethods(PacketParserUtils.parseCompressionMethods(xmlPullParser));
                    continue;
                }
                if (!xmlPullParser.getName().equals("register")) continue;
                this.connection.serverSupportsAccountCreation();
                continue;
            }
            if (n != 3) continue;
            if (xmlPullParser.getName().equals("starttls")) {
                this.connection.startTLSReceived(bl2);
                continue;
            }
            if (xmlPullParser.getName().equals("required") && bl) {
                bl2 = true;
                continue;
            }
            if (!xmlPullParser.getName().equals("features")) continue;
            bl3 = true;
        }
        if (!this.connection.isSecureConnection() && !bl && this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new SmackException.SecurityRequiredException();
        }
        if (!bl || this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.lastFeaturesParsed = true;
            PacketReader packetReader = this;
            synchronized (packetReader) {
                this.notify();
            }
        }
    }
}

